<?php

namespace App\Http\Controllers;

use App\Models\Categorie;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CategorieController extends GenericController
{
    public function __construct()
    {
        $this->setModel(new Categorie());
    }

    public function index(){
        return parent::getList();
    }

    public function save(Request $request)
    {
        if($request->get('_id')!=0){
            $this->setModel(Categorie::find($request->get('_id')));
        }
        $redirect = parent::add($request);

        return $redirect;
    }

    public function apiliste($begin=null, $size=null){
        $list =  DB::table('categories');
        if($begin!=null) $list = $list->skip($begin);
        if($size!=null) $list = $list->take($size);
        $list = $list->select('id','name')->get();

        return response()->json([
            'categories'=>$list,
            'status'=>'OK'
        ],200);
        
    }
}
