<?php

namespace App\Http\Controllers;

use App\Models\Log;
use Illuminate\Http\Request;

class GenericController extends Controller
{
    protected  $model;

    /**
     * @return mixed
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * @param mixed $model
     */
    public function setModel($model)
    {
        $this->model = $model;
    }

    public function init(){

    }

    public function add($request){

        $inputs = $request->input();
        $model_class = get_class($this->model);
        $methode_v = $this->model->getValidateMethode();
         $v = $model_class::$methode_v($request);

        if(!$v->passes()){
            return redirect()->back()->withErrors($v)->withInput();
        }

        $fields = $this->model->getFields();
        $belongsTos = $this->model->getBelongsTo();
        $belongsToManys = $this->model->getBelongsToMany();
        $otherModels = $this->model->getOtherModels();

        while ($field = key($fields)) {
            if(!in_array($field,array_keys($belongsTos)) && !in_array($field,array_keys($belongsToManys)) && !in_array($field,$this->model->getHiddens()) && !in_array($field,$this->model->getFieldsHiddens())){
                if(in_array($field,$this->model->getFiles()) || in_array($field,$this->model->getImages())){
                    //return $this->model->getFiles();
                    if($request->hasFile($field)){
                        $imagefile = $request->file($field);
                        $ext = $imagefile->getClientOriginalExtension();
                        $file = uniqid() . '.' . $ext;
                        $imagefile->move($this->model->getUploadsFolder(), $file);
                        $this->model->$field = $this->model->getUploadsFolder().$file;
                    }elseif ($this->model->id!=null && $request->has('old_'.$field)){
                        $this->model->$field = null;
                    }
                }elseif(in_array($field,$this->model->getPasswords())){
                    if($inputs[$field]!='' && $request->has($field))
                        $this->model->$field = \Hash::make($inputs[$field]);
                }elseif (in_array($field,array_keys($this->model->getSelectsMultiple()))){
                    $str='';
                    if($request->has($field)){
                        foreach ($inputs[$field] as $data){
                            $str.='~'.$data;
                        }
                        $this->model->$field = $str;
                    }else{
                        $this->model->$field = null;
                    }
                } elseif (in_array($field,$this->model->getDates())){
                    if(!empty($request->get($field))){
                        $this->model->$field =  date('Y-m-d',strtotime(str_replace('/','-',$inputs[$field])));
                    }
                } elseif (in_array($field,$this->model->getDatetimes())){
                    if(!empty($request->get($field))){
                        $this->model->$field =  date('Y-m-d H:i:s',strtotime(str_replace('/','-',$inputs[$field])));
                    }
                }else{
                    if($request->has($field))
                        $this->model->$field = $inputs[$field];
                    else
                        $this->model->$field = null;
                }
            }
            next($fields);
        }

        while ($belongsTo = key($belongsTos)) {
            if(!in_array($belongsTo,$this->model->getFieldsHiddens())){
                $key = $belongsTo.'_id';
                if($request->has($key))
                    $this->model->$key = $inputs[$key];
                else
                    $this->model->$key = null;
            }
            next($belongsTos);
        }

        while ($belongsToMany = key($belongsToManys)) {
            $methode = $belongsToMany.'()';
            $key = $belongsToMany.'_id';
            if($request->has($key)){
                $this->model->$methode->detach($inputs[$key]);
                $this->model->$methode->attach($inputs[$key]);
            }
            next($belongsToManys);
        }



        if($this->model->save()){
            $log = new Log();
            if($request->get('_id')==0){
                $log->action='create:'.$this->model->getTable();
                $log->user_id=\Auth::user()->id;
                $log->description='Création d\'un nouvel élément de '.$this->model->getTitle();

                foreach ($otherModels as $otherModel){
                    $belongsTos = $otherModel->getBelongsTo();
                    $fields = $otherModel->getFields();
                    while ($field = key($fields)) {
                        if(!in_array($field,array_keys($belongsTos)) && !in_array($field,$otherModel->getHiddens()) && !in_array($field,$otherModel->getFieldsHiddens())){
                            if(in_array($field,array_keys($this->model->getFields()))){
                                $otherModel->$field = $this->model->$field;
                            }elseif(in_array($field,$otherModel->getPasswords())){
                                if($inputs[$field]!='' &&  $request->has($field))
                                    $otherModel->$field = \Hash::make($inputs[$field]);
                            }else{
                                if($request->has($field))
                                    $otherModel->$field = $inputs[$field];
                            }
                        }
                        next($fields);
                    }

                    while ($belongsTo = key($belongsTos)) {
                        if(!in_array($belongsTo,$otherModel->getFieldsHiddens())){
                            $str = substr($this->model->getTable(), 0,strlen($this->model->getTable())-1);
                            $key = $belongsTo.'_id';
                            if($belongsTo!=$str){
                                if($request->has($key))
                                    $otherModel->$key = $inputs[$key];
                            }else{
                                $otherModel->$key = $this->model->id;
                            }
                        }

                        next($belongsTos);
                    }

                    $otherModel->save();
                }
            }
            else{
                $log->action='update:Id='.$request->get('_id').':'.$this->model->getTable();
                $log->user_id=\Auth::user()->id;
                $log->description='Modification de '.$this->model->getTitle();
            }

            $log->save();
            if($request->has('redirectTo')){
                return redirect($request->get('redirectTo'))->with('succes','Opération effectuée avec succès..');
            }
            return redirect()->back()->with('succes','Opération effectuée avec succès..');
        }
        else return redirect()->back()->with('error','Erreur lors de l\'opération.')->withInput();
    }

    public function getList($wheres=null, $whereIns=null, $orderBys=null, $begin=null, $size=null,$view_params=null){

       /* $log= new Log();
        $log->action='listing:'.$this->model->getTable();
        $log->user_id=\Auth::user()->id;
        $log->description='Affichacge de la liste des '.$this->model->getTitle();
        $log->save()*/;

        $model_class = get_class($this->getModel());

        $list = $model_class::select('*');
        if($wheres!=null){
            foreach ($wheres as $where){
                $list = $list->where($where[0],$where[1],$where[2]);
            }
        }

        if($whereIns!=null){
            foreach ($whereIns as $whereIn){
                $list = $list->whereIn($whereIn[0],$whereIn[1]);
            }
        }

        if($orderBys!=null){
            foreach ($orderBys as $orderBy){
                $list = $list->orderBy($orderBy[0],$orderBy[1]);
            }
        }

        if($begin!=null){
            $list = $list->skip($begin);
        }

        if($size!=null){
            $list = $list->take($size);
        }

        $list = $list->get();
        $titles = array_values($this->model->getFields());
        $columns = array_keys($this->model->getFields());


        $view_data = ['elements'=>$list,'titles'=>$titles,'columns'=>$columns,'model'=>$this->model];
       if($view_params!=null){
           while ($key = key($view_params)) {
               $view_data[$key] = $view_params[$key];
               next($view_params);
           }

       }


        return view($this->model->getViewList(),$view_data);
    }

    public function delete($parent_id=null,$_id=null,Request $request){
        if($_id==null)
            $_id = $parent_id;
        $log= new Log();
        $log->action='delete:Id='.$_id.':'.$this->model->getTable();
        $log->user_id=\Auth::user()->id;
        $log->description='Suppression d\'un élément de  '.$this->model->getTitle();
        $log->save();

        $model_class = get_class($this->model);
        $data = $model_class::find($_id);
        if($data!=null)
            $data->delete();
        return 1;
    }

    public function edit(Request $request, $parent_id=null,$_id=null){
        if($_id==null)
            $_id = $parent_id;
        $object=\DB::table($this->model->getTable())->where('id', '=', $_id)->first();

        return response()->json([
            'model'=>$object
        ],200);
    }

    public function ajax_select(Request $request){
        $fk = $request->get('filter_key');
        $fv = $request->get('filter_value');

        $data_key = $request->get('data_key');
        $data_title = $request->get('data_title');

        $model_class = $request->get('model_class');
        $model = new $model_class();

        $name=substr($model->getTable(),0,strlen($model->getTable())-1).'_id';

        $listes = $model->getAll([[$fk,'=',$fv]]);

        return view('inc.cruds.select_ajax_from_model',['listes'=>$listes,'name'=>$name,'title'=>$data_title,'column_name'=>$data_key]);
    }



}
