<?php

namespace App\Http\Controllers;
use App\Models\Article;
use App\Models\Maintenance;
use App\Models\Maire;
use App\Models\Projet;
use App\Models\Statu;
use App\Utils\Agbonon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Analytics\Period;
use Analytics;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        return view('admin.home');
    }


    public function statVisite(Request $request)
    {
        return view('admin.ajax.stat_visite',['type_chart'=>$request->get('type_chart')]);
    }

    public function siteMap(){
        return view('plan-site');
    }

    public function search(Request $request){
        return view('search-result', compact('request'));
    }


    public function statSugg(Request $request){
        return view('admin.suggestions.suggestion-input', compact('request'));
    }

    public function subCategories(Request $request){
        return view('admin.ajax.subcategorie', compact('request'));
    }

    public function extMessage(Request $request){
        return view('admin.blank-page', compact($request));
    }


    public function lateJobNotification(Request $request){
        $today =  date('Y-m-d');
        $days_before = date('Y-m-d', strtotime($today. ' -7 days'));
        $lateJobs = Maintenance::select('*')
            ->where('created_at','<=',''.$days_before.'')
            ->where('statu_id','<>',''.Statu::COMPLETED_CONFIRMED.'')
            ->where('statu_id','<>',''.Statu::REJECT.'')
            ->get();
        if($lateJobs->count()>0){
            $lateJobs =  Maintenance::apiListObject($lateJobs);
            //return view('emails.late-jobs',['late_jobs'=>$lateJobs]);
            //'hashem.nader@resto-group.com',  'kankoe.agbonon@cedicomgroup.com'
            $emails = ['ashraf.bahrawi@resto-group.com'];
            //$emails = ['kankoe.agbonon@cedicomgroup.com'];
            $data = ['late_jobs'=>$lateJobs];
            foreach ($emails as $email){
                Agbonon::sendMail('emails.late-jobs',$email,'Overdue maintenance tasks', $data, 'mainte@resto-group.com','Maintenance Sys');
            }
        }
    }
}
