<?php

namespace App\Http\Controllers;

use App\Models\Device;
use App\Models\History;
use App\Models\Maintenance;
use App\Models\Profil;
use App\Models\Statu;
use App\Models\Store;
use App\Models\User;
use App\Utils\Agbonon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class MaintenanceController extends GenericController
{

    public function __construct()
    {
        $this->setModel(new Maintenance());
    }

    public function index($dtype){
        $pageTitle = '';
        $statuIds  = [];
        if($dtype=='open') {
            $pageTitle = 'Open';
            $statuIds = Statu::OPEN_STATUS;
        }
        if($dtype=='awaiting') {
            $pageTitle = 'Awaiting';
            $statuIds = Statu::AWAITING_STATUS;
        }
        if($dtype=='closed') {
            $pageTitle = 'Closed';
            $statuIds = Statu::CLOSED_STATUS;
        }
        $status = DB::table('status')->whereIn('id', $statuIds)->get();
        $stores = DB::table('stores')->get();
        $categories = DB::table('categories')->get();
        $subcategories = DB::table('subcategories')->get();
        $users = DB::table('users')->get();
        return view('admin.maintenances.list', compact('dtype','pageTitle','status','stores','categories','subcategories','users'));
    }

    public function ajaxList(Request  $request){
        return  view('admin.ajax.maintenance-list', compact('request'));
    }

    public function formAdd($maintenance_id=null){
        $maintenance =  new Maintenance();
        return view('admin.maintenances.add', compact('maintenance'));
    }

    public function edit(Request $request, $dtype=null,$_id=null){
        $maintenance  = Maintenance::find($_id);
        //if($dtype)
        return view('admin.maintenances.add', compact('maintenance'));
    }

    public function save(Request $request){
        if(!empty($request->get('maintenance_id'))) $maintenance = Maintenance::find($request->get('maintenance_id'));
        else $maintenance = new Maintenance();
        $maintenance->store_id = $request->get('store_id');
        $maintenance->subject = $request->get('subject');
        $maintenance->categorie_id = $request->get('categorie_id');
        $maintenance->subcategorie_id = $request->get('subcategorie_id');
        $maintenance->store_id = $request->get('store_id');
        $maintenance->description = $request->get('description');
        if($request->hasFile('photo')){
            $maintenance->photos = '';
            $imagefile = $request->file('photo');
            $ext = $imagefile->getClientOriginalExtension();
            $file = uniqid() . '.' . $ext;
            $imagefile->move($this->model->getUploadsFolder(), $file);
            $maintenance->photos = $this->model->getUploadsFolder().$file;
        }
        $maintenance->statu_id = Statu::LOGGED;
        $maintenance->created_user_id = Auth::user()->id;
        if($maintenance->save()){
            $maintenance->number = 'JN'.Agbonon::generateID1($maintenance->id);
            $maintenance->save();
            if(empty($request->get('maintenance_id'))){
                History::saveHistory($maintenance->id,Auth::user()->id,Statu::LOGGED);
                $officerEmails = DB::table('users')
                    ->whereIn('profil_id',[Profil::MAINTENANCE_OFFICER, Profil::MAINTENANCE_SUPPERVISOR])
                    ->select('email')->pluck('email')->toArray();

                $data = ['issue'=>$maintenance];

                foreach ($officerEmails as $officerEmail){
                    if(!empty($officerEmail)) Agbonon::sendMail('emails.new-issue',$officerEmail,'New issue', $data, 'mainte@restogroup.com','Maintenance Sys');
                }
            }
        }
        return redirect()->back()->with('succes','Operation performed successfully..');
    }

    public function apisave(Request $request){

        if(empty($request->get('subject'))){
            return response()->json([
                'status'=>'NONOK',
                'msg_title'=>'Error',
                'msg_content'=> 'The short description is required.',
            ],200);
        }

        if(!empty($request->get('maintenance_id'))) $maintenance = Maintenance::find($request->get('maintenance_id'));
        else $maintenance = new Maintenance();
        $maintenance->store_id = $request->get('store_id');
        $maintenance->subject = $request->get('subject');
        $maintenance->categorie_id = $request->get('categorie_id');
        $maintenance->subcategorie_id = $request->get('subcategorie_id');;
        $maintenance->description = !empty($request->get('description'))? $request->get('description') : ' ';
        $nb_photos = $request->get('nb_photo');
        $photo_paths = '';
        for ($i=1; $i<$nb_photos; $i++){
            if($request->hasFile('photo_'.$i)){
                $imagefile = $request->file('photo_'.$i);
                $ext = $imagefile->getClientOriginalExtension();
                $file = uniqid() . '.' . $ext;
                $imagefile->move($this->model->getUploadsFolder(), $file);
                $photo_paths.=';'.$this->model->getUploadsFolder().$file;
            }
        }
        $photo_paths = !empty($photo_paths)? substr($photo_paths,1) : '';
        if(!empty($photo_paths)) {
            $maintenance->photos =  $photo_paths;
        }elseif (!empty($request->get('old_photos'))){
            $maintenance->photos = $request->get('old_photos');
        }

        $action = $request->get('action');
        $msg = '';
        if($maintenance->save()){
            if(empty($request->get('maintenance_id')) && $action=='add'){
                $maintenance->number = 'JN'.Agbonon::generateID1($maintenance->id);
                $maintenance->statu_id = Statu::LOGGED;
                $maintenance->created_user_id = Auth::user()->id;
                History::saveHistory($maintenance->id,Auth::user()->id,Statu::LOGGED);
                $msg = 'The maintenance was created successfully.';
            }

            if($action=='validate') {
                $maintenance->supervisor_user_id = Auth::user()->id;
                $maintenance->officer_user_id = null;
                $maintenance->statu_id = Statu::VALIDATED;
                History::saveHistory($maintenance->id,Auth::user()->id,Statu::VALIDATED);
                $msg = 'Maintenance has been successfully validated.';
            }
            if($action=='edit'){
                $msg = 'Maintenance has been successfully modified.';
            }
            $maintenance->save();

            $store = Store::find( $request->get('store_id'));
            $store_name = !empty($store)? $store->name : '';

            if(in_array($action, ['add','validate'])){
                $n_message = '';
                $officers = DB::table('users');
                if($action=='add')  {
                    $officers =  $officers->whereIn('profil_id',[Profil::MAINTENANCE_SUPPERVISOR, Profil::ADMIN]);
                    $n_message = "A new issue from $store_name requires your validation";
                }
                if($action=='validate')  {
                    // Profil::ADMIN
                    $officers =  $officers->whereIn('profil_id',[Profil::MAINTENANCE_OFFICER]);
                    $n_message = "New maintenance from $store_name requires your action";
                }

                $officers = $officers->select('email','id')->get();
                $officerEmails = $officers->pluck('email')->toArray();
                $officerIds = $officers->pluck('id')->toArray();

                $devices = Device::getDeviceByUser($officerIds);
                $pushTokens =  $devices->whereNotNull('push_token')->pluck('push_token')->toArray();

                $data = ['issue'=>$maintenance];
                foreach ($officerEmails as $officerEmail){
                    if(!empty($officerEmail)) Agbonon::sendMail('emails.new-issue',$officerEmail,'New issue', $data, 'mainte@resto-group.com','Maintenance Sys');
                }

                $n_title = 'New maintenance';
                if(count($pushTokens)>0) {
                    $data = ['maintenance'=>Maintenance::apiObject($maintenance),'dtype'=>'new_job'];
                    Agbonon::sendFirebaseNotification($n_title, $n_message, null, 1, $pushTokens, $data);
                }
            }
        }

        return response()->json([
            'status'=>'OK',
            'msg_title'=>'Success',
            'msg_content'=> $msg,
        ],200);

    }

    public function apiliste(Request  $request, $begin=null, $size=null){
        $authId = Auth::user()->id;

        $dtype =  !empty($request->get('data-type'))? $request->get('data-type') :  null;
        $start_date = !empty($request->get('start_date'))? date('Y-m-d 00:00',strtotime($request->get('start_date'))) : null;
        $end_date = !empty($request->get('end_date'))? date('Y-m-d 00:00',strtotime($request->get('end_date'))) : null;

        $statu_ids = !empty($request->get('statu_id'))? explode(';',$request->get('statu_id') ):  null;
        $categorie_ids = !empty($request->get('categorie_id'))? explode(';',$request->get('categorie_id')) :  null;
        $subcategorie_ids = !empty($request->get('subcategorie_id'))? explode(';',$request->get('subcategorie_id')) :  null;
        $supervisor_user_id = !empty($request->get('supervisor_user_id'))? $request->get('supervisor_user_id') :  null;
        $officer_user_id = !empty($request->get('officer_user_id'))? $request->get('officer_user_id') :  null;
        $created_user_id = !empty($request->get('created_user_id'))? $request->get('created_user_id') :  null;

        $owner_id = $dtype=='for-me'? $authId :  null;

        if(!empty($request->get('store_id'))){
            $store_ids = !empty($request->get('store_id'))? explode(';', $request->get('store_id')) :  null;
        }else{
            $store_ids = DB::table('store_user')
                ->where('user_id', $authId)
                ->select('store_id')->pluck('store_id')->toArray();
        }

        //$statu_ids =  !empty($statu_ids)? explode(';',$statu_ids) :  null;
        $maintenances = Maintenance::liste($request->search,$owner_id,$dtype,$start_date,$end_date,$statu_ids,$store_ids,$categorie_ids,$subcategorie_ids,$supervisor_user_id,$officer_user_id,$created_user_id,$begin,$size);
        $data = [];
        foreach ($maintenances as $m){
            $store = $m->store;
            $categorie = $m->categorie;
            $subcategorie = $m->subcategorie;
            $photos = !empty($m->photos)? explode(';', $m->photos) : [];
            $createdUser = DB::table('users')->where('id',$m->created_user_id)->first();
            $data[] = [
                'id'=> $m->id,
                'number'=> $m->number,
                'subject'=> $m->subject,
                'description'=> $m->description,
                'photo'=> count($photos)>0? $photos[0] : '',
                'photos'=> $photos,
                'store'=> ['id'=>$store->id, 'name'=>$store->name],
                'category'=> ['id'=>$categorie->id, 'name'=>$categorie->name],
                'subcategory'=> !empty($subcategorie)? ['id'=>$subcategorie->id, 'name'=>$subcategorie->name, 'categorie_id'=>$subcategorie->categorie_id] : ['name'=>''],
                'status'=> $m->statu->name,
                'status_color'=> Statu::STATUS_COLORS[$m->statu_id],
                'author_name'=> $createdUser? $createdUser->name : '',
                'author_email'=> $createdUser? $createdUser->email : '',
                'officer_name'=> !empty($m->officerUser)? $m->officerUser->name : '',
                'supervisor_name'=> !empty($m->supervisorUser)? $m->supervisorUser->name : '',
                'created_time'=> date('H:i', strtotime($m->created_at)),
                'created_date'=> date('d-m-Y', strtotime($m->created_at)),
                'is_job'=> $m->statu_id!=null && !in_array($m->statu_id, [Statu::LOGGED, Statu::VALIDATED])
            ];
        }


        $can_add =  Auth::user()->can_add_issue;
        return response()->json([
            'maintenances'=>$data,
            'can_add_issue' => $can_add==1,
            'status'=>'OK'
        ],200);
    }

    public function apidetail($_id){
        $m =  Maintenance::find($_id);
        if($m!=null){
            $status = Profil::getStatus(Auth::user()->profil_id);
            $accept = $status->where('id', Statu::ACCEPT)->first();
            $reject = $status->where('id', Statu::REJECT)->first();
            $validate = $status->where('id', Statu::VALIDATED)->first();

            $store = $m->store;
            $categorie = $m->categorie;
            $subcategorie = $m->subcategorie;

            $createdUser = DB::table('users')->where('id',$m->created_user_id)->first();
            $data = [
                'id'=> $m->id,
                'number'=> $m->number,
                'subject'=> $m->subject,
                'photos'=> !empty($m->photos)? explode(';', $m->photos) : [],
                'store'=> ['id'=> $store->id, 'name'=> $store->name],
                'category'=> ['id'=>$categorie->id, 'name'=>$categorie->name],
                'subcategory'=> !empty($subcategorie)? ['id'=>$subcategorie->id, 'name'=>$subcategorie->name, 'categorie_id'=>$subcategorie->categorie_id] : ['name'=>''],
                'status'=> $m->statu->name,
                'status_color'=> Statu::STATUS_COLORS[$m->statu_id],
                'author_name'=> $createdUser? $createdUser->name : '',
                'author_email'=> $createdUser? $createdUser->email : '',
                'officer_name'=> !empty($m->officerUser)? $m->officerUser->name : '',
                'supervisor_name'=> !empty($m->supervisorUser)? $m->supervisorUser->name : '',
                'created_time'=> date('H:i', strtotime($m->created_at)),
                'created_date'=> date('d-m-Y', strtotime($m->created_at)),
                'description'=> $m->description,
                'start_time'=> date('H:i', strtotime($m->created_at)),
                'start_date'=> date('d-m-Y', strtotime($m->created_at)),
                'end_time'=> date('H:i', strtotime($m->created_at)),
                'end_date'=> date('d-m-Y', strtotime($m->created_at)),

                'accept'=>$m->statu_id==Statu::VALIDATED? $accept : null,
                'reject'=>$m->statu_id==Statu::LOGGED || ($m->statu_id==Statu::VALIDATED && Auth::user()->profil_id==Profil::ADMIN)? $reject : null,
                'validate'=>$m->statu_id==Statu::LOGGED? $validate : null,

                'is_job'=> $m->statu_id!=null && !in_array($m->statu_id, [Statu::LOGGED, Statu::VALIDATED])

                //'canEdit'=>$m->statu_id==Statu::LOGGED,
            ];

            $histories = History::select('*')->where('maintenance_id', $_id)->get();
            $history = [];
            foreach ($histories as $h){
                $history[] =[
                    'author_name'=> $h->user? $h->user->name : 'User deleted',
                    'status'=>$h->statu->name,
                    'status_color'=> Statu::STATUS_COLORS[$h->statu_id],
                    'remark'=>$h->remark,
                    'photos'=>!empty($h->photos)? explode(';',$h->photos) : [],
                    'created_time'=> date('H:i', strtotime($h->created_at)),
                    'created_date'=> date('d-m-Y', strtotime($h->created_at)),
                ];
            }
            $data['history'] = $history;

            $status_data = [];
            if($m->statu_id!=null){
                $profil_status =  $status->pluck('id')->toArray();
                $tabStatus = DB::table('statu_statu')
                    ->where('statu_id', $m->statu_id)
                    ->select('nextstatu_id')
                    ->get()->pluck('nextstatu_id')
                    ->toArray();

                $status_list = DB::table('status')
                    ->whereIn('id', $tabStatus)
                    ->whereIn('id', $profil_status)
                    ->select('id','name')
                    ->get();

                $status_data = [];
                foreach ($status_list as $s){
                    $s->require_remark = in_array($s->id, [Statu::QUOTE_NEEDED, Statu::AWAITING_PART, Statu::NOT_SOLVED]);
                    $status_data[] = $s;
                }
            }

            return response()->json([
                'maintenance'=>$data,
                'status_list'=>$status_data,
                'status'=>'OK'
            ],200);
        }else{
            return response()->json([
                'status'=>'NONOK',
                'msg_title'=>'Error',
                'msg_content'=>"Maintenance not available",
            ],200);
        }
    }

    public function saveStatus(Request $request){
        $maintenance = Maintenance::find($request->get('_id'));
        if($maintenance!=null){
            $status = $request->get('action');
            $reason_reject = $request->get('reason');
            $photo_likns= '';
            $msg = "Maintenance status is updated successfully";
            if($status==Statu::ACCEPT) {
                $msg = "This maintenance has been accepted successfully";
            }
            if($status==Statu::REJECT) {
                $msg = "This maintenance has been rejected successfully";
            }
            if(in_array($status, [Statu::ACCEPT , Statu::REJECT])){
                if($maintenance->officer_user_id!=null) {
                    $user = User::find($maintenance->officer_user_id);
                    return response()->json([
                        'status'=>'NONOK',
                        'msg_title'=>'Warning',
                        'msg_content'=>"Oups! This maintenance has been accepted by another agent : $user->name",
                    ],200);
                }
               // $maintenance->officer_user_id = Auth::user()->id;
            }
            elseif (in_array($status, [Statu::QUOTE_NEEDED, Statu::AWAITING_PART, Statu::NOT_SOLVED])){
                $nb_photos = $request->get('nb_photo');
                for ($i=1; $i<$nb_photos; $i++){
                    if($request->hasFile('photo_'.$i)){
                        $imagefile = $request->file('photo_'.$i);
                        $ext = $imagefile->getClientOriginalExtension();
                        $file = uniqid() . '.' . $ext;
                        $imagefile->move($this->model->getUploadsFolder(), $file);
                        $photo_likns.=';'.$this->model->getUploadsFolder().$file;
                    }
                }
                $photo_likns = !empty($photo_likns)? substr($photo_likns,1) : '';
            }
            $maintenance->reason_reject = $reason_reject;
            $maintenance->statu_id = $status;

            if($status == Statu::VALIDATED){
                $maintenance->supervisor_user_id = Auth::user()->id;
            }
            if($status == Statu::ACCEPT){
                $maintenance->officer_user_id = Auth::user()->id;
            }
            if($status==Statu::STARTED) $maintenance->start_date =  date('Y-m-d H:i:s');
            if($status==Statu::COMPLETED_CONFIRMED) $maintenance->end_date =  date('Y-m-d H:i:s');
            $maintenance->save();
            History::saveHistory($maintenance->id, Auth::user()->id, $status,$reason_reject,$photo_likns);
            $statusObject = Statu::find($status);
            $statu_name =  !empty($statusObject)? $statusObject->name :  '';
            $jobId = $maintenance->number;
            $n_title = "New status #$jobId";
            $data = ['maintenance'=>Maintenance::apiObject($maintenance),'dtype'=>'job'];
            $n_message = "The status of job #$jobId has ben updated to $statu_name";
            $user_ids =  User::getUsersByMaintenance($maintenance);
            $pushTokens = DB::table('devices')->whereIn('user_id', $user_ids)
                ->whereNotNull('push_token')->pluck('push_token')->toArray();
            ///topics/ALL_DEVICE_SEGMENT
            Agbonon::sendFirebaseNotification($n_title, $n_message, null, 1, $pushTokens, $data);

            return response()->json([
                'status'=>'OK',
                'msg_title'=>'Success',
                'msg_content'=> $msg,
            ],200);
        }
        return response()->json([
            'status'=>'NONOK',
            'msg_title'=>'Error',
            'msg_content'=>'Resource not available',
        ],200);
    }

    public function awaitingPart(Request  $request, $begin=null, $size=null){
        $data = History::select('*')
            ->join('maintenances','maintenances.id','=','historys.maintenance_id')
            ->where('maintenances.statu_id',Statu::AWAITING_PART)
            ->whereNotNull('remark');

        if($begin!=null) $data =  $data->skip($begin);
        if($size!=null) $data =  $data->take($size);

        $data =  $data->select('historys.remark','historys.photos','historys.user_id','historys.statu_id','maintenances.number as job_number','historys.created_at')->get();

        $historys = [];
        foreach ($data as $h){
            $historys[] =[
                'job_number'=>$h->job_number,
                'author_name'=>!empty($h->user)? $h->user->name : '',
                'status'=>$h->statu->name,
                'status_color'=> Statu::STATUS_COLORS[$h->statu_id],
                'remark'=>$h->remark,
                'photos'=>!empty($h->photos)? explode(';',$h->photos) : [],
                'created_time'=> date('H:i', strtotime($h->created_at)),
                'created_date'=> date('d-m-Y', strtotime($h->created_at)),
            ];
        }
        return response()->json([
            'status'=>'OK',
            'msg_title'=>'Success',
            'awaiting_parts'=> $historys,
        ],200);
    }
    public function detailJob($job_id){
        $issue =  Maintenance::find($job_id);
        return view('admin.maintenances.maintenance-detail', compact('issue'));
    }

    //controller de verification des statuts des tâches
    public function checkStatus(Request  $request){
        $nbreMaintenancesSolvedByUser = DB::table('maintenances')->where('statu_id', Statu::COMPLETED)
                                                        ->where('created_user_id',Auth::user()->id)
                                                        ->count();
        if($nbreMaintenancesSolvedByUser!=0){
            return response()->json([
                'status'=>'NONOK',
                'msg_title'=>'Error',
                'msg_content'=> "You have $nbreMaintenancesSolvedByUser issue solved not validated\nYou must validate before creating new",
            ],200);
        }else{
            return response()->json([
                'status'=>'OK',
                'msg_title'=>'Success',
            ],200);
        }
    }
      //Recupérations des utilisateurs liés à un problème de maintenance
      public function issueUsers(Request $request,$id_maintenance=null){
        $id_m = $id_maintenance;
        $user_auth_id = Auth::user()->id;
        $users_id = History::select('user_id')->where('maintenance_id',$id_m)->where('user_id','<>', $user_auth_id)->pluck('user_id')->toArray();

        $users = User::select('id','name','whatsapp_phone')->whereIn('id', $users_id);

        $technicians =  User::select('id','name','whatsapp_phone')->whereIn('profil_id', [Profil::MAINTENANCE_OFFICER, Profil::MAINTENANCE_SUPPERVISOR, Profil::ADMIN])
                        ->whereNotIn('id', [1,9])
                        ->union($users)->get();

        return response()->json([
            'status'=>'OK',
            'msg_title'=>'Success',
            'users'=> $technicians,
            'msg_content'=> "",
        ],200);
    }


}
