<?php

namespace App\Http\Controllers;

use App\Models\Maintenance;
use App\Models\Message;
use App\Models\Profil;
use App\Models\User;
use App\Utils\Agbonon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MessageController extends Controller
{
    public function saveMessage(Request $request){
        $message_id = $request->get('message_id');
        $maintenance = Maintenance::find($request->get('maintenance_id'));
        if(!empty($maintenance)){
            $authId =  Auth::user()->id;
            $m = empty($message_id)? new Message() : Message::find($message_id);
            $m->maintenance_id =  $maintenance->id;
            $m->message = $request->get('message');
            $m->user_id = $authId;
            $m->save();

            $messages = Message::liste($maintenance->id);

            $message_list = [];
            foreach ($messages as $data){
                $message_list[] = [
                    'id'=>$data->id,
                    'message'=>$data->message,
                    'author_name'=> $data->author_name,
                    'form_me' => $data->user_id == $authId,
                    'created_time'=> date('H:i', strtotime($data->created_at)),
                    'created_date'=> date('d-m-Y', strtotime($data->created_at)),
                ];
            }

            $jobId = $maintenance->number;
            $n_title = "New message #$jobId";
            $data = ['maintenance'=>Maintenance::apiObject($maintenance),'dtype'=>'chat'];
            $n_message = $m->message;

            $user_ids =  User::getUsersByMaintenance($maintenance);
            $pushTokens = DB::table('devices')->whereIn('user_id', $user_ids)
                ->whereNotNull('push_token')->pluck('push_token')->toArray();

            ///topics/ALL_DEVICE_SEGMENT
            Agbonon::sendFirebaseNotification($n_title, $n_message, null, 1, $pushTokens, $data);

            return response()->json([
                'status'=>'OK',
                'msg_title'=>'Success',
                'msg_content'=>"Message sent successfully",
                'messages'=>$message_list,
            ],200);
        }
        return response()->json([
            'status'=>'NONOK',
            'msg_title'=>'Error',
            'msg_content'=>"Maintenance not available",
        ],200);
    }

    public function listMessage(Request $request, $begin=null, $size=null){
        $maintenance_id = !empty($request->get('maintenance_id'))? $request->get('maintenance_id') : null;
        $messages = Message::liste($maintenance_id);
        $authId =  Auth::user()->id;
        $message_list = [];
        foreach ($messages as $data){
            $message_list[] = [
                'id'=>$data->id,
                'message'=>$data->message,
                'author_name'=> $data->author_name,
                'form_me' => $data->user_id == $authId,
                'created_time'=> date('H:i', strtotime($data->created_at)),
                'created_date'=> date('d-m-Y', strtotime($data->created_at)),
            ];
        }
        return response()->json([
            'status'=>'OK',
            'messages'=>$message_list,
        ],200);
    }
}
