<?php

namespace App\Http\Controllers;

use App\Models\Statu;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class StatuController extends GenericController
{
    public function __construct()
    {
        $this->setModel(new Statu());
    }

    public function index(){
        return parent::getList();
    }

    public function formAdd(){
        $titles = array_values($this->model->getFields());
        $columns = array_keys($this->model->getFields());
        return view('admin.status.add',['titles'=>$titles,'columns'=>$columns,'model'=>$this->model,'']);
    }

    public function edit( Request $request, $parent_id=null,$_id=null){
        $_id = $parent_id;
        $model = Statu::find($_id);
        $titles = array_values($model->getFields());
        $columns = array_keys($model->getFields());
        return view('admin.status.add',['titles'=>$titles,'columns'=>$columns,'model'=>$model]);
    }

    public function save(Request $request)
    {
        if($request->get('_id')!=0){
            $this->setModel(Statu::find($request->get('_id')));
        }

        $belongsToMany= $this->model->getBelongsToMany();
        $fields = $this->model->getFields();
        unset($fields['profil']) ;
        unset($fields['statu']) ;
        unset($belongsToMany['profil']) ;
        unset($belongsToMany['statu']) ;
        $this->model->setFields($fields);
        $this->model->setBelongsToMany($belongsToMany);

        $redirect = parent::add($request);

        if($this->model->id!=null){
            $this->model->profils()->detach();
            if($request->has('profil_id') && is_array($request->get('profil_id'))){
                foreach ($request->get('profil_id') as $p){
                    $this->model->profils()->attach($p);
                }
            }

            $this->model->status()->detach();
            if($request->has('statu_id') && is_array($request->get('statu_id'))){
                foreach ($request->get('statu_id') as $p){
                    $this->model->status()->attach($p);
                }
            }
        }

        return $redirect;
    }


    public function apiliste($begin=null, $size=null){

        $list =  DB::table('status')
            ->select('id','name')->distinct()
            ->get();

        /*$list =  DB::table('status')
            ->join('profil_statu','profil_statu.statu_id','=','status.id')
            ->where('profil_id',Auth::user()->profil_id)
            ->select('id','name')->distinct()
            ->get();*/
        return response()->json([
            'status_list'=>$list,
            'status'=>'OK'
        ],200);
    }




}
