<?php

namespace App\Http\Controllers;

use App\Models\Store;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class StoreController extends GenericController
{
    public function __construct()
    {
        $this->setModel(new Store());
    }

    public function index(){
        return parent::getList();
    }

    public function save(Request $request)
    {
        if($request->get('_id')!=0){
            $this->setModel(Store::find($request->get('_id')));
        }
        $redirect = parent::add($request);

        return $redirect;
    }

    public function apiliste($begin=null,$size=null){
        $list =  DB::table('stores');
        if($begin!=null) $list = $list->skip($begin);
        if($size!=null) $list = $list->take($size);

        if(Auth::check()){
            $list->join('store_user','store_user.store_id','=', 'stores.id')
                ->where('store_user.user_id',Auth::user()->id);
        }

        $list = $list->select('stores.id','stores.name')->distinct()->get();

        return response()->json([
            'stores'=>$list,
            'status'=>'OK'
        ],200);
    }
}
