<?php

namespace App\Http\Controllers;


use App\Models\Categorie;
use App\Models\Device;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserController extends GenericController
{
    public function __construct()
    {
        $this->setModel(new User());
    }

    public function index(){
        return parent::getList();
    }

    public function formAdd(){
        $titles = array_values($this->model->getFields());
        $columns = array_keys($this->model->getFields());

        $belongsToMany= $this->model->getBelongsToMany();
        $belongsToMany = ['store'=>'name']+$belongsToMany;
        $this->model->setBelongsToMany($belongsToMany);

        return view('admin.users.add',['titles'=>$titles,'columns'=>$columns,'model'=>$this->model]);
    }

    public function edit(Request $request, $parent_id=null,$_id=null){
        $_id = $parent_id;
        $model = User::find($_id);
        $titles = array_values($model->getFields());
        $columns = array_keys($model->getFields());

        $belongsToMany= $model->getBelongsToMany();
        $belongsToMany = ['store'=>'name']+$belongsToMany;
        $model->setBelongsToMany($belongsToMany);

        return view('admin.users.add',['titles'=>$titles,'columns'=>$columns,'model'=>$model]);
    }

    public function save(Request $request)
    {

        //return  var_dump($this->model->getFields());
        if($request->get('_id')!=0){
            $this->setModel(User::find($request->get('_id')));
            $this->model->setValidateMethode('validate2');
        }
        $this->model->companie_id = 1;

        $fields = $this->model->getFields();
        unset($fields['store']) ;
        $this->model->setFields($fields);

        $redirect = parent::add($request);

        if($this->model->id!=null){
            $this->model->stores()->detach();
            if($request->has('store_id') && is_array($request->get('store_id'))){
                foreach ($request->get('store_id') as $p){
                    $this->model->stores()->attach($p);
                }
            }
            $this->model->categories()->detach();
            foreach (Categorie::all() as $c){
                if($request->has('check_c'.$c->id)) $this->model->categories()->attach($c->id);
            }
        }

        return $redirect;
    }

    public function login(Request $request){
        $username = $request->get('username');
        $password = $request->get('password');
        if(!empty($username) && !empty($password)){
            $credentials = ['username' => $username, 'password' => $password];
            if (Auth::attempt($credentials)) {
                $u = Auth::user();
                if($u->is_active){
                    if($u->auth_token==null) $u->auth_token = Hash::make($u->id);
                    $u->save();
                    $u->setHidden(['password', 'remember_token']);
                    return response()->json([
                        'status'=>'OK',
                        'msg_title'=>'Succès',
                        'msg_content'=>'Welcome.',
                        'user'=>$u,
                    ],200);
                }else{
                    return response()->json([
                        'status'=>'INACTIF',
                        'msg_title'=>'Avertissement',
                        'msg_content'=>"Your account is inactive! Use the code received during registration to activate it.",
                    ],200);
                }
            }

            return response()->json([
                'status'=>'NONOK',
                'msg_title'=>'Erreur',
                'msg_content'=>'The login information provided is not correct',
            ],200);
        }
        return response()->json([
            'status'=>'NONOK',
            'msg_title'=>'Erreur',
            'msg_content'=>'Please enter login information',
        ],200);
    }

    public function unauthorized(){
        return response()->json([
            'status'=>'NONOK',
            'msg_title'=>'Avertissement',
            'msg_content'=>"Votre compte est inactif! Veuillez contacter l'adminitrateur pour remidier à celà.",
        ],403);
    }

    public function saveDevice(Request $request){
        if(!empty($request->get('push_token'))){
            $user = User::findByToken($request->get('app_token'));
            $device = Device::findByToken($request->get('push_token'));
            if($device==null) $device = new Device();
            if($user!=null)  $device->user_id =  $user->id;
            $device->push_token = $request->get('push_token');
            $device->platform = $request->get('platform');
            $device->app_version = $request->get('app_version');
            $device->provider = $request->get('provider');
            $device->save();
            return response()->json([
                'status'=>'OK',
                'msg_title'=>'Succès',
                'msg_content'=>'Succès',
            ],200);
        }
        return response()->json([
            'status'=>'NONOK',
            'msg_title'=>'Erreur',
            'msg_content'=>'Erreur',
        ],200);
    }

}
