<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(!empty($request->header('AuthToken'))){
            $user = User::findByToken($request->header('AuthToken'));
            if($user!=null && $user->is_active){
                Auth::loginUsingId($user->id);
                return $next($request);
            }
        }
        return redirect('api/unauthorized');
    }
}
