<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class VerifyAppClient
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $country = !empty($request->header('Country'))? $request->header('Country') : 'GABON';
        if($country == 'LIBAN'){
            config(['database.connections.mysql.database' => 'nader_rg_maintenance_liban']);
        }elseif($country == 'CIV'){
            config(['database.connections.mysql.database' => 'nader_rg_maintenance_ci']);
        }else{
            config(['database.connections.mysql.database' => 'nader_rg_maintenance']);
        }
        return $next($request);
    }
}
