<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Brand extends GenericModel
{
    use HasFactory;

    protected $table = 'brands';
    protected $title = 'Brands';
    protected $primaryKey = 'id';
    protected $fields = [
        'companie'=>'Companie',
        'name'=>'Nom',
    ];

    protected $actions = ['add','edit','delete'];
    protected $belongsTo= ['companie'=>'name'];

    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function companie(){
        return $this->belongsTo(Companie::class);
    }
}
