<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Categorie extends GenericModel
{
    use HasFactory;

    protected $table = 'categories';
    protected $title = 'Categories';
    protected $primaryKey = 'id';
    protected $fields = [
        'name'=>'Nom',
    ];

    protected $actions = ['add','edit','delete'];


    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function subcategories(){
        return $this->hasMany(Subcategorie::class);
    }

}
