<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Companie extends GenericModel
{
    use HasFactory;


    protected $table = 'companies';
    protected $title = 'Companies';
    protected $primaryKey = 'id';
    protected $fields = [
        'name'=>'Nom',
        'email'=>'Email',
        'logo'=>'URL'
    ];

    protected $actions = ['add','edit','delete'];
    protected $columns_hiddens = ['logo'];
    protected $images = ['logo'];
    protected $uploads_folder = 'uploads/companies/';


    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [

        ];
        return \Validator::make($request->input(),$rules,$messages);
    }


    public function brands(){
        return $this->hasMany(Brand::class);
    }

    public function stores(){
        return $this->hasMany(Store::class);
    }

    public function users(){
        return $this->hasMany(User::class);
    }

}
