<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends GenericModel
{
    use HasFactory;

    protected $table = 'countrys';
    protected $title = 'Countries';
    protected $primaryKey = 'id';
    protected $fields = [
        'name'=>'Nom',
    ];

    protected $actions = ['add','edit','delete'];

    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function regions(){
        return $this->hasMany(Region::class);
    }
}
