<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class History extends Model
{
    use HasFactory;

    protected $table = 'historys';
    protected $title = 'Historys';
    protected $primaryKey = 'id';


    public static function saveHistory($maintenance_id, $user_id, $statu_id, $remark=null, $photos =null){
        $history =  new History();
        $history->maintenance_id = $maintenance_id;
        $history->user_id = $user_id;
        $history->statu_id = $statu_id;
        $history->remark = $remark;
        $history->photos = $photos;
        $history->save();
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function maintenance(){
        return $this->belongsTo(Maintenance::class);
    }

    public function statu(){
        return $this->belongsTo(Statu::class);
    }
}
