<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Log extends GenericModel
{
    protected $table = 'logs';
    protected $title = 'Journal';
    protected $primaryKey = 'id';
    protected $fields = [
        'created_at'=>'Date',
        'user'=>'Adr. Utilisateur',
        'action'=>'Action',
        'description'=>'Description',
    ];
    protected $belongsTo = ['user'=>'email'];

    protected $actions = ['delete'];
    protected $datetimes= ['created_at'];

    public function user(){
        return $this->belongsTo(User::class);
    }
}
