<?php

namespace App\Models;

use App\Utils\Agbonon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;

class Maintenance extends GenericModel
{
    use HasFactory;

    protected $table = 'maintenances';
    protected $title = 'Maintenances';
    protected $primaryKey = 'id';
    protected $fields = [
        'number'=>'N°',
        'subject'=>'Subject',
        'description'=>'Description',
        'start_date'=>'Start date',
        'end_date'=>'End date'
    ];

    protected $actions = ['add','edit','delete'];
    protected $longTexts= ['description'];
    protected $columns_hiddens= ['description'];

    protected $uploads_folder = 'uploads/maintenances/';

    public function categorie(){
        return $this->belongsTo(Categorie::class);
    }

    public function subcategorie(){
        return $this->belongsTo(Subcategorie::class);
    }

    public function store(){
        return $this->belongsTo(Store::class);
    }

    public function statu(){
        return $this->belongsTo(Statu::class);
    }

    public function createdUser(){
        return $this->belongsTo(User::class,'created_user_id');
    }

    public function supervisorUser(){
        return $this->belongsTo(User::class,'supervisor_user_id');
    }

    public function officerUser(){
        return $this->belongsTo(User::class,'officer_user_id');
    }

    public function btnOptions($profil_status){
        $url_redirect =  URL::previous();
        $detail_url= url('maintenance/'.$this->id.'/detail');

        $str ='<div class="btn-group">
                <button type="button" class="btn btn-primary btn-xs dropdown-toggle waves-effect" data-toggle="dropdown" aria-expanded="false"> Options <span class="caret text-white"></span> </button>
                    <ul class="dropdown-menu" style="margin-left: -55px">';

        //btn-preview-job
        $btn_preview = '<a  href="'.$detail_url.'" class="btn btn-xs waves-effect waves-light btn-default m-b-5">Preview</a>';
        $btn_edit = '<a _id="'.$this->id.'" class="btn btn-xs waves-effect waves-light btn-primary cmd-edit-btn m-b-5">Edit</a>';
        $btn_cancel = '<a _id="'.$this->id.'" redirect="'.$url_redirect.'" class="btn btn-xs waves-effect waves-light btn-danger cmd-cancel-btn m-b-5">Cancel</a>';
        $str.='<li>'.$btn_preview.'</li>';

        if($this->statu_id!=null){
            $status_list =  DB::table('status')
                ->join('statu_statu','statu_statu.nextstatu_id','=','status.id')
                ->where('statu_statu.statu_id', $this->statu_id)
                ->whereIn('id', $profil_status)
                ->whereNotIn('id', [Statu::QUOTE_NEEDED, Statu::AWAITING_PART])
                ->select('id','name')
                ->get();

            $require_remark = 0;
            //$require_remark = in_array($this->id, [Statu::QUOTE_NEEDED, Statu::AWAITING_PART])? 1 : 0;


            foreach ($status_list as $s){
                $btn_generic = '<a redirect_url="'.$url_redirect.'" status="'.$s->id.'" _id="'.$this->id.'" require_remark="'.$require_remark.'" class="btn btn-xs waves-effect waves-light btn-default btn-manage-status m-b-5" style="color : '.Statu::STATUS_COLORS[$s->id].'">'.$s->name.'</a>';
                $str.='<li>'.$btn_generic.'</li>';
            }
        }


        /*$str.='<li>'.$btn_edit.'</li>';
        $str.='<li>'.$btn_cancel.'</li>';*/

        $str.='</ul></div>';

        return $str;
    }

    public static function liste($search='', $owner_id=null, $data_type=null, $start_date=null, $end_date=null,$statu_ids=null, $store_ids=null, $categorie_ids=null, $subcategorie_ids=null, $supervisor_user_id=null, $officer_user_id=null, $created_user_id=null, $begin=null, $size=null){
        $maintenances = Maintenance::select('*');
        if($begin!=null) $maintenances = $maintenances->skip($begin);
        if($size!=null) $maintenances = $maintenances->take($size);
        if(!empty($start_date)) $maintenances =$maintenances->where('created_at','>=',''.$start_date.'');
        if(!empty($start_date)) $maintenances= $maintenances->where('created_at','<=',''.$end_date.'');
        if(!empty($data_type) && $data_type!='for-me'){
            $statuIds  = [];
            if($data_type=='pending')  $statuIds = \App\Models\Statu::PENDIND_STATUS;
            if($data_type=='in-progress')  $statuIds = \App\Models\Statu::INPROGRESS_STATUS;
            if($data_type=='closed') $statuIds = \App\Models\Statu::CLOSED_STATUS;
            if($data_type=='open') $statuIds = \App\Models\Statu::OPEN_STATUS;
            if($data_type=='awaiting') $statuIds = \App\Models\Statu::AWAITING_STATUS;
            $maintenances = $maintenances->whereIn('statu_id',$statuIds);

        }
        if(!empty($statu_ids)) $maintenances = $maintenances->whereIn('statu_id',$statu_ids);
        if(!empty($store_ids)) $maintenances = $maintenances->whereIn('store_id',$store_ids);
        if(!empty($categorie_ids)) $maintenances = $maintenances->whereIn('categorie_id',$categorie_ids);
        if(!empty($subcategorie_ids)) $maintenances = $maintenances->whereIn('subcategorie_id', $subcategorie_ids);

        if(!empty($supervisor_user_id)) $maintenances = $maintenances->where('supervisor_user_id',$supervisor_user_id);
        if(!empty($officer_user_id)) $maintenances = $maintenances->where('officer_user_id',$officer_user_id);
        if(!empty($created_user_id)) $maintenances = $maintenances->where('created_user_id',$created_user_id);

        if(!empty($owner_id)){
            $maintenances =  $maintenances->where(function ($query) use ($owner_id) {
                $query->where('supervisor_user_id', $owner_id)
                    ->orWhere('officer_user_id',$owner_id)
                    ->orWhere('created_user_id',$owner_id);
            });
        }

        if(!empty($search)){
            $maintenances = $maintenances->where(function ($query) use ($search) {
                $query->where('maintenances.number','like','%'.$search.'%');
                   // ->orWhere('typepromoters.name','like','%'.$search.'%');
            });
        }

        $maintenances = $maintenances
            ->orderBy('created_at', 'desc')
            ->orderBy('view', 'asc')
            ->get();

        return $maintenances;
    }


    public static function apiObject(Maintenance $m){
        $store = $m->store;
        $categorie = $m->categorie;
        $subcategorie = $m->subcategorie;
        $photos = !empty($m->photos)? explode(';', $m->photos) : [];
        $data = [
            'id'=> $m->id,
            'number'=> $m->number,
            'subject'=> $m->subject,
            'description'=> $m->description,
            'photo'=> count($photos)>0? $photos[0] : '',
            'photos'=> $photos,
            'store'=> ['id'=>$store->id, 'name'=>$store->name],
            'category'=> ['id'=>$categorie->id, 'name'=>$categorie->name],
            'subcategory'=> !empty($subcategorie)? ['id'=>$subcategorie->id, 'name'=>$subcategorie->name, 'categorie_id'=>$subcategorie->categorie_id] : null,
            'status'=> $m->statu->name,
            'status_color'=> Statu::STATUS_COLORS[$m->statu_id],
            'author_name'=> $m->createdUser->name,
            'author_email'=> $m->createdUser->email,
            'officer_name'=> !empty($m->officerUser)? $m->officerUser->name : '',
            'supervisor_name'=> !empty($m->supervisorUser)? $m->supervisorUser->name : '',
            'created_time'=> date('H:i', strtotime($m->created_at)),
            'created_date'=> date('d-m-Y', strtotime($m->created_at)),
            'is_job'=> $m->statu_id!=null && !in_array($m->statu_id, [Statu::LOGGED, Statu::VALIDATED])
        ];

        return  $data;
    }

    public static function apiListObject($maintenances){
        $data = [];
        foreach ($maintenances as $m){
            $store = $m->store;
            $categorie = $m->categorie;
            $subcategorie = $m->subcategorie;
            $photos = !empty($m->photos)? explode(';', $m->photos) : [];
            $data[] = [
                'id'=> $m->id,
                'number'=> $m->number,
                'subject'=> $m->subject,
                'description'=> $m->description,
                'photo'=> count($photos)>0? $photos[0] : '',
                'photos'=> $photos,
                'store'=> ['id'=>$store->id, 'name'=>$store->name],
                'category'=> ['id'=>$categorie->id, 'name'=>$categorie->name],
                'subcategory'=> !empty($subcategorie)? ['id'=>$subcategorie->id, 'name'=>$subcategorie->name, 'categorie_id'=>$subcategorie->categorie_id] : null,
                'status'=> $m->statu->name,
                'status_color'=> Statu::STATUS_COLORS[$m->statu_id],
                'author_name'=> $m->createdUser->name,
                'author_email'=> $m->createdUser->email,
                'officer_name'=> !empty($m->officerUser)? $m->officerUser->name : '',
                'supervisor_name'=> !empty($m->supervisorUser)? $m->supervisorUser->name : '',
                'created_time'=> date('H:i', strtotime($m->created_at)),
                'created_date'=> date('d-m-Y', strtotime($m->created_at)),
                'is_job'=> $m->statu_id!=null && !in_array($m->statu_id, [Statu::LOGGED, Statu::VALIDATED])
            ];
        }
        return  $data;
    }


    public static function validateEnreg($request){
        $rules = [
            'subject' => 'required',
            'store_id' => 'required',
            'categorie_id' => 'required',
            'subcategorie_id' => 'required',
        ];
        $messages = [
            'subject.required' => "The short description is required.",
        ];
        return \Validator::make($request->input(),$rules,$messages);
    }
}
