<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Menu extends GenericModel
{
    protected $table = 'menus';
    protected $title = 'Menus';
    protected $primaryKey = 'id';
    protected $fields = [
        'menu'=>'Menu parent',
        'name'=>'Nom',
        'url'=>'URL',
        'icone'=>'Icone',
    ];

    protected $actions = ['add','edit','delete'];
    protected $columns_hiddens = ['url', 'icone'];
    protected $belongsTo= ['menu'=>'name'];


    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [

        ];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function menu(){
        return $this->belongsTo(Menu::class);
    }

    public function menus(){
        return $this->hasMany(Menu::class)->orderBy('created_at')->orderBy('ordre');
    }
}
