<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Message extends Model
{
    use HasFactory;

    public static function liste($maintenance_id=null, $user_id=null){
        $data =  DB::table('messages')
            ->join('users','users.id','=','messages.user_id')
            ->join('maintenances','maintenances.id','=','messages.maintenance_id');

        if($maintenance_id!=null) $data =  $data->where('maintenance_id', $maintenance_id);
        if($user_id!=null) $data =  $data->where('user_id', $user_id);

        return $data->orderBy('created_at','asc')->select('messages.*','users.name as author_name')->get();
    }
}
