<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Profil extends Model
{
    use HasFactory;

    public const ADMIN = 1;
    public const OPERATIONAL_MANAGER = 2;
    public const STORE_MANAGER = 3;
    public const MAINTENANCE_OFFICER = 4;
    public const MAINTENANCE_SUPPERVISOR = 5;

    public static function getStatus($profil_id){
        $data = DB::table('status')
            ->join('profil_statu','profil_statu.statu_id','=','status.id')
            ->where('profil_statu.profil_id',$profil_id)
            ->select('status.id','status.name')
            ->get();
        return $data;
    }
}
