<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Region extends GenericModel
{
    use HasFactory;

    protected $table = 'regions';
    protected $title = 'Region';
    protected $primaryKey = 'id';
    protected $fields = [
        'country'=>'Country',
        'name'=>'Nom',
    ];

    protected $actions = ['add','edit','delete'];
    protected $belongsTo= ['country'=>'name'];

    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function country(){
        return $this->belongsTo(Country::class);
    }
}
