<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Statu extends GenericModel
{
    use HasFactory;

    public const ACCEPT = 1;
    public const REJECT = 2;
    public const STARTED = 3;
    public const QUOTE_NEEDED = 4;
    public const AVAILABLE_PART = 5;
    public const COMPLETED = 6;
    public const LOGGED = 7;
    public const COMPLETED_CONFIRMED = 8;
    public const AWAITING_PART = 9;
    public const VALIDATED = 10;

    public const RE_STARTED = 11;
    public const NOT_SOLVED = 12;

    public const PENDIND_STATUS= [Statu::LOGGED,Statu::STARTED, Statu::VALIDATED, Statu::RE_STARTED, Statu::NOT_SOLVED];
    public const INPROGRESS_STATUS=  [Statu::ACCEPT,Statu::QUOTE_NEEDED,Statu::AVAILABLE_PART,Statu::COMPLETED,Statu::AWAITING_PART];
    public const CLOSED_STATUS= [Statu::COMPLETED_CONFIRMED,Statu::REJECT];

    public const OPEN_STATUS= [Statu::LOGGED,Statu::STARTED,Statu::ACCEPT,Statu::AVAILABLE_PART,Statu::COMPLETED,Statu::VALIDATED, Statu::RE_STARTED, Statu::NOT_SOLVED];
    public const AWAITING_STATUS= [Statu::AWAITING_PART,Statu::QUOTE_NEEDED];


    public const STATUS_COLORS = [
        Statu::LOGGED => '#039be5',
        Statu::ACCEPT => '#008000',
        Statu::STARTED => '#fea30a',
        Statu::QUOTE_NEEDED => '#ff0000',
        Statu::AVAILABLE_PART => '#fea30a',
        Statu::COMPLETED => '#ff69b3',
        Statu::AWAITING_PART => '#ff0000',
        Statu::COMPLETED_CONFIRMED => '#008000',
        Statu::REJECT => '#ff0000',
        Statu::VALIDATED => '#3ac9d6',
        Statu::RE_STARTED => '#fea30a',
        Statu::NOT_SOLVED => '#ff0000',
    ];

    protected $table = 'status';
    protected $title = 'Status';
    protected $primaryKey = 'id';
    protected $fields = [
        'name'=>'Nom',
        'statu'=>'Next possible status',
        'profil'=>'Profils can view',
    ];

    protected $actions = ['edit'];
    protected $belongsToMany = ['profil'=>'name','statu'=>'name'];
    protected $custom_columns= ['profil'=>'getProfils','statu'=>'getStatus'];

    protected $form_modal = 'form_standard';
    protected $view_list = 'admin.inc.cruds.list_sans_form';

    public static function validate($request){
        $rules = [
            'name' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public function profils(){
        return $this->belongsToMany(Profil::class);
    }

    public function status(){
        return $this->belongsToMany(Statu::class,'statu_statu','statu_id','nextstatu_id');
    }

    public function getProfils(){
        $str = '';
        foreach ($this->profils as $profil){
            $str.=$profil->name.'<br/>';
        }
        return $str;
    }

    public function getStatus(){
        $str = '';
        foreach ($this->status as $statu){
            $str.=$statu->name.'<br/>';
        }
        return $str;
    }


}
