<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Store extends GenericModel
{
    use HasFactory;

    protected $table = 'stores';
    protected $title = 'Stores';
    protected $primaryKey = 'id';
    protected $fields = [
        'companie'=>'Companie',
        'brand'=>'Brand',
        'name'=>'Nom',
        'phone'=>'Phone',
        'email_notif'=>'Emails de notification',
        'address'=>'Address',
        'region'=>'Region',
    ];

    protected $actions = ['add','edit','delete'];
    protected $belongsTo= ['companie'=>'name','brand'=>'name','region'=>'name'];
    protected $columns_hiddens= ['companie','email_notif','address'];
    protected $longTexts= ['address'];
    protected $tag_inputs= ['email_notif'];

    public static function validate($request){
        $rules = [
            'name' => 'required',
            'brand_id' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }


    public function companie(){
        return $this->belongsTo(Companie::class);
    }

    public function brand(){
        return $this->belongsTo(Brand::class);
    }

    public function region(){
        return $this->belongsTo(Region::class);
    }
}
