<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subcategorie extends GenericModel
{
    use HasFactory;

    protected $table = 'subcategories';
    protected $title = 'Sub Categories';
    protected $primaryKey = 'id';
    protected $fields = [
        'categorie'=>'Nom',
        'name'=>'Nom',
    ];

    protected $actions = ['add','edit','delete'];
    protected $belongsTo= ['categorie'=>'name'];

    public static function validate($request){
        $rules = [
            'name' => 'required',
            'categorie_id' => 'required',
        ];
        $messages = [];
        return \Validator::make($request->input(),$rules,$messages);
    }


    public function categorie(){
        return $this->belongsTo(Categorie::class);
    }
}
