<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;

class User extends Authenticatable
{
    use HasFactory, Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $table = 'users';
    protected $title = 'Utilisateurs';
    protected $primaryKey = 'id';
    protected $fields = [
        'profil'=>'Profil',
        'name'=>'Name',
        'email'=>'Email',
        'store'=>'Stores',
        'username'=>'Username',
        'password'=>'Password',
        'password_confirmation'=>'Confirm Password',
        'is_active'=>'Active account',
        'can_add_issue'=>'Can add issue',
        'whatsapp_phone'=>'Whatsapp Number'
    ];

    protected $actions = ['edit','add','delete'];
    protected $belongsTo = ['profil'=>'name'];
    protected $form_modal = 'form_standard';
    protected $view_list = 'admin.inc.cruds.list_sans_form';
    protected $passwords = ['password','password_confirmation'];
    protected $selects = ['is_active'=>[1=>'Yes',0=>'No'], 'can_add_issue'=>[1=>'Yes',0=>'No']];
    protected $hiddens = ['password_confirmation'];
    protected $columns_hiddens= ['password_confirmation','password','activated','store'];


    public function profil(){
        return $this->belongsTo(Profil::class);
    }

    public function stores(){
        return $this->belongsToMany(Store::class);
    }

    public function categories(){
        return $this->belongsToMany(Categorie::class);
    }

    public static function validate($request){
        $rules = [
            'username' => 'required|unique:users,username,'.$request->get('_id'),
            'password' => 'required|confirmed',
            'is_active' => 'required',
            'profil_id' => 'required',
        ];
        $messages = [
            'username.required' => "L'adresse mail est obligatoire.",
            'username.unique' => "Ce username existe déjà.",
            'password.required' => "Le mot de passe est obligatoire.",
            'password.confirmed' => "Confirmation de mot de passe échouée.",
            'is_active.required' => "Veuillez indiquer si le compte est actif ou pas.",
        ];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public static function validate2($request){
        $rules = [
            'username' => 'required|unique:users,username,'.$request->get('_id'),
            'password' => 'confirmed',
            'is_active' => 'required',
            'profil_id' => 'required',
        ];
        /*if($request->get('password')!='')
            $rules['password'] = 'confirmed|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/';*/
        $messages = [
            'username.required' => "L'adresse mail est obligatoire.",
            'username.unique' => "Ce username existe déjà.",
            'password.confirmed' => "Confirmation de mot de passe échouée.",
            'password.min' => "Le mot de passe doit contenir au moins 8 caractères",
            'is_active.required' => "Veuillez indiquer si le compte est actif ou pas.",
            'profil_id.required' => "Le profil est obligatoire.",
        ];
        return \Validator::make($request->input(),$rules,$messages);
    }

    public static function findByToken($auth_token){
        $user = User::select('*')
            ->where('auth_token','=',''.$auth_token.'')
            ->first();
        return $user;
    }

    public static function getUsersByMaintenance($maintenance){
        $user_ids = DB::table('store_user')
            ->where('store_id', $maintenance->store_id)
            ->select('user_id')
            ->pluck('user_id')
            ->toArray();
        return $user_ids;
    }
}
