<?php
/**
 * Created by PhpStorm.
 * User: Gabi
 * Date: 21/10/2017
 * Time: 10:56
 */

namespace App\Utils;

use Illuminate\Support\Facades\Route;

use Illuminate\Support\Str;

class Agbonon
{

    const ONESIGNAL_APP_ID = 'ce0323a6-4ae2-4ee5-ad25-a68e0974de95';
    const ONESIGNAL_REST_KEY = 'YTg4MzZiZTAtYzVlZC00ZmQ0LTk3MTMtZDZkZDBkNmUzOWQ4';

    public static $profil_home = [
        '1'=>'admin.home-admin',
        '2'=>'admin.home-operator',
        '3'=>'admin.home-shop',
    ];

    public static $cmd_types = ['delivery'=>'Livraison','pickup'=>'A emporter'];
    public static $cmd_status = ['En attente','Acceptée','Annulée' ,'Refusée','En route','Livrée'];
    public static $cmd_colors = [
        'En attente' => '#ef6b00',
        'Acceptée'=>'#039be5',
        'Annulée'=>'#ff0000',
        'Refusée'=>'#ff0000',
        'En route'=>'#fea30a',
        'Livrée'=>'#008000',
    ];

    public static $date_lang = [
      'monday'=>'lundi',
      'tuesday'=>'mardi',
      'wednesday'=>'mercredi',
      'thursday'=>'jeudi',
      'friday'=>'vendredi',
      'saturday'=>'samedi',
      'sunday'=>'dimanche',
    ];

    public static $date_sub = [
        'lundi'=>'lun',
        'mardi'=>'mar',
        'mercredi'=>'mer',
        'jeudi'=>'jeu',
        'vendredi'=>'ven',
        'samedi'=>'sam',
        'dimanche'=>'dim',
    ];

    public static $month_sub = [
        '01'=>'jan',
        '02'=>'fév',
        '03'=>'mar',
        '04'=>'avr',
        '05'=>'mai',
        '06'=>'juin',
        '07'=>'juil',
        '08'=>'août',
        '09'=>'sept',
        '10'=>'oct',
        '11'=>'nov',
        '12'=>'déc',
    ];

    public static $months = [
        '01'=>'janvier',
        '02'=>'février',
        '03'=>'mars',
        '04'=>'avril',
        '05'=>'mai',
        '06'=>'juin',
        '07'=>'juillet',
        '08'=>'août',
        '09'=>'septembre',
        '10'=>'octobre',
        '11'=>'novembre',
        '12'=>'décembre',
    ];

    public static function date($format, $date){
        if($date==null || str_contains($date,'1970-01-01')|| str_contains($date,'0000-00-00'))
            return '';
        return date($format,strtotime($date));
    }

    public static function crudResource($name,$controller){
        Route::get($name,$controller.'@index');
        Route::get($name.'/edit/{_id}',$controller.'@edit');
        Route::get($name.'/delete/{_id}',$controller.'@delete');
        Route::post($name,$controller.'@save');
    }


    public static function generateID1($id){
        if($id<10)
            $str='000'.$id;
        elseif ($id<100)
            $str='00'.$id;
        elseif ($id<1000)
            $str='0'.$id;
        else
            $str=$id;
        return $str;
    }

    public static function generateID($id){
        if($id<10)
            $str='0000'.$id;
        elseif ($id<100)
            $str='000'.$id;
        elseif ($id<1000)
            $str='00'.$id;
        elseif ($id<10000)
            $str='0'.$id;
        else
            $str=$id;

        return $str;
    }

    public static function generateQrcode($id){
        if($id<10)
            $str='0000000'.$id;
        elseif ($id<100)
            $str='000000'.$id;
        elseif ($id<1000)
            $str='00000'.$id;
        elseif ($id<10000)
            $str='0000'.$id;
        elseif ($id<100000)
            $str='000'.$id;
        elseif ($id<1000000)
            $str='00'.$id;
        elseif ($id<10000000)
            $str='0'.$id;
        else
            $str=$id;

        return $str;
    }

    public static function lastID($table){
        return \DB::table($table)->max('id');
    }

    public static  function afficher_date($date = null){
        date_default_timezone_set('Africa/Libreville');
        if(\App::getLocale()=='fr')
            setlocale(LC_TIME, 'fr_FR.utf8','fra');

        $return = null;
        $return .= strftime("%A %d %B %Y", strtotime($date));

        return $return;
    }

    public static  function afficher_month_of_date($date = null){
        date_default_timezone_set('Africa/Libreville');
        if(\App::getLocale()=='fr')
            setlocale(LC_TIME, 'fr_FR.utf8','fra');
        $return = null;
        $return .= strftime("%B", strtotime($date));

        return $return;
    }

    public static function afficher_date_time($date = null){
        date_default_timezone_set('Africa/Libreville');
        if(\App::getLocale()=='fr')
            setlocale(LC_TIME, 'fr_FR.utf8','fra');

        $return = null;
        $return .= strftime("%A %d %B %Y", strtotime($date));
        $return .= " : ".date("G", strtotime($date))."h".date("i", strtotime($date));

        return $return;
    }

    public static function afficher_date_time_san_jour($date = null){
        date_default_timezone_set('Africa/Libreville');
        setlocale(LC_TIME, 'fr_FR.utf8','fra');
        $return = null;
        $return .= strftime("%d %B %Y", strtotime($date));
        $return .= " : ".date("G", strtotime($date))."h".date("i", strtotime($date));

        return $return;
    }

    public static function afficher_date_sans_jour($date = null){
        date_default_timezone_set('Africa/Libreville');
        setlocale(LC_TIME, 'fr_FR.utf8','fra');
        $return = null;
        $return .= strftime("%d %B %Y", strtotime($date));
       // $return .= " : ".date("G", strtotime($date));

        return $return;
    }

    public static function afficher_date_event($date = null)
    {
        date_default_timezone_set('Africa/Libreville');
        setlocale(LC_TIME, 'fr_FR.utf8', 'fra');
        $return = null;
        $return .= "Date événement : " . strftime("%d %B %Y", strtotime($date));
        $return .= " à " . date("G", strtotime($date)) . "h" . date("i", strtotime($date));

        return $return;
    }



    public static function scanDirectories($rootDir, $allData=array()) {

        $invisibleFileNames = array(".", "..", ".htaccess", ".htpasswd");

        $dirContent = scandir($rootDir);
        foreach($dirContent as $key => $content) {

            $path = $rootDir.'/'.$content;
            if(!in_array($content, $invisibleFileNames)) {

                if(is_file($path) && is_readable($path)) {

                    $allData[] = $path;

                }elseif(is_dir($path) && is_readable($path)) {

                    $allData = Agbonon::scanDirectories($path, $allData);
                }
            }
        }
        return $allData;
    }

    public static function addDayToDate($date, $days){

    }

    public static  function setEnvironmentValue($envKey, $envValue)
    {
        $envFile = app()->environmentFilePath();
        $str = file_get_contents($envFile);

        $f = fopen($envFile, "r");
        feof($f);

        while (!feof($f)) {
            $ligne = fgets($f, 4096);
            $elt = explode("=", $ligne);
            if($elt[0]==$envKey){
                $oldValue = $elt[1];
                break;
            }
        }
        fclose($f);



        $str = str_replace("{$envKey}={$oldValue}", "{$envKey}={$envValue}\n", $str);

        $fp = fopen($envFile, 'w');
        fwrite($fp, $str);
        fclose($fp);
    }


    public static function sendMail($view, $to, $subject, $data, $sender, $name){
        /*try{
            \Mail::send($view,$data, function($message) use ($to,$subject,$sender,$name) {
                $message->from($sender,$name);
                $message->to($to);
                $message->replyTo($sender, $name);
                $message->subject($subject);
            });
        }catch (\Exception $e){}*/
        
        return true;
    }

    public static function nommbre_de_jour($datedeb,  $datefin){
        $date1 = strtotime($datedeb);
        $date2 = strtotime($datefin);
        $nbJoursTimestamp = $date2 - $date1;
        $nbJours = $nbJoursTimestamp/86400; // 86 400 = 60*60*24
        return (int) $nbJours;
    }

    public function getSondagesPositions(){
        return [
            'accueil','aricle',
            'evenement',
            'etablissement','mon_cpte',
            'espace_annoce','contact',
            'result_recherche','conpetition'
        ];
    }

    public static function verifCaptcha($data){
        $ch = curl_init();

        $values = 'secret='.env('SECRET_CAPTCHA').'&response='.$data;
        curl_setopt($ch, CURLOPT_URL,"https://www.google.com/recaptcha/api/siteverify");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $values);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close ($ch);
        $server_output = json_decode($server_output);

        return $server_output->success;

        //if ($server_output == "OK") { ... } else { ... }
    }


    public static function filterFieldLang($model){
        $parametre = Parametre::find(1);

        $active_lang = explode('~',$parametre->active_lang);

        $fields = $model->getFields();

        if(!in_array('EN', $active_lang)){
            foreach ($fields as $key=>$field){
                if (Str::endsWith($key, '_en')){
                    unset($fields[$key]);
                }
            }
        }

        $model->setFields($fields);
    }

    public static function fileSize($size){
        if($size<1024) $size=$size.' o';
        elseif($size<1048576) $size=round($size=$size/1024,0).' Ko';
        elseif($size<1073741824) $size=round($size=$size/1048576,0).' Mo';
        else $size=round($size=$size/1073741824,0).' Go';
        return $size;
    }


    public static function getBrentPrice(){
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization: Token 2805c3636d58dcfed9c964d32dbb6164',
            'Content-Type: application/json'
        ));
        curl_setopt($ch, CURLOPT_URL,"https://api.oilpriceapi.com/v1/prices/latest");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close ($ch);
        $server_output = json_decode($server_output);

        if($server_output->status=='success')
            return $server_output->data;
        return null;

        //if ($server_output == "OK") { ... } else { ... }
    }

    public  static function currencyConverter($from, $to, $amount) {
        $url = 'http://openexchangerates.org/api/latest.json?app_id=084649db450043839efa0de1f74bbe3c&base='.$from;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close ($ch);

        $server_output = json_decode($server_output);
        return  round($server_output->rates->$to*$amount);
    }

    public static function sendFirebaseNotification($title, $message, $image,  $badge, $token, $data){
        try {
            $url = "https://fcm.googleapis.com/fcm/send";
            $serverKey = 'AAAA7vsdbLg:APA91bF1qMU4e6knLyG8ZgrFhd89g3wi6p6Ul-yyQAkNBDvEU6lqOykGRqRCuGOleO-m-JQxq0NtEChm09BaMgbdiVLjd_Buc6Bcy5ZqrQCKfNRiePpEJD5BIczgS2fmX6wQycIHM8ry';

            $notification = array(
                'title' =>$title ,
                'body' => strip_tags($message),
                'sound' => 'to_the_point',
                'badge' => $badge,
                'priority'=>'high',
                "click_action" => 'FLUTTER_NOTIFICATION_CLICK',
                "android_channel_id" => 'APP_NOTIFICATION',
                "android"=>[
                    'priority'=>'high',
                ],
            );

            if($image!=null){
                $notification['image'] = $image;
            }

            $data['priority'] = 'high';
            $data['android_channel_id'] = 'APP_NOTIFICATION';
            $data['sound'] = 'to_the_point';

            $arrayToSend = array(
                'notification' => $notification,
                'data' => $data,
                'priority'=>'high',
                "click_action" => 'FLUTTER_NOTIFICATION_CLICK',
                "content_available" => true,
                "android_channel_id" => 'APP_NOTIFICATION',
                "headers"=>[
                    "apns-priorty" => "10",
                    "apns-push-type" => 'alert',
                ],
                'sound' => 'to_the_point',
                "android"=>[
                    'priority'=>'high',
                ],
            );

            if(is_array($token)){
                $arrayToSend['registration_ids'] = $token;
            }else{
                $arrayToSend['to'] = $token;
            }

            $json = json_encode($arrayToSend);
            $headers = array();
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'Authorization: key='. $serverKey;
            $headers[] = 'apns-push-type=alert';

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);

            $response = curl_exec($ch);

            if ($response === FALSE) {
                //return 'FCM Send Error: ' .curl_error($ch);
            }
            curl_close($ch);

            //return $response;
        }catch (\Exception $exception){
            //return 'Erro';
        }
    }


    public static function setSmartview($key, $value, $content){
        return str_replace($key, $value, $content);
    }

    public static function verifySMS($mobile_number, $code){

        $arrayToSend = array(
            'otp_id'=>$mobile_number,
            'otp_code'=>$code,
        );

        $jsonParams = json_encode($arrayToSend);
        $curl = curl_init();

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://donald544-mocean-moceanapi-v1.p.rapidapi.com/rest/1/sms",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "mocean-to=$mobile_number",
            CURLOPT_HTTPHEADER => array(
                "content-type: application/x-www-form-urlencoded",
                "x-rapidapi-host: donald544-mocean-moceanapi-v1.p.rapidapi.com",
                "x-rapidapi-key: OFPYm1Kt8QmshVLJnmCpaXoEubVLp1LrK7xjsnDvgReAaAd00a"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }

    }

    public  static function getOldQte($produit_id, $items){
        foreach ($items as $item){
            if($item['produit_id']==$produit_id)
                return $item['produit_qte'];
        }
        return '';
    }

    public  static function getOldIndication($produit_id, $items){
        foreach ($items as $item){
            if($item['produit_id']==$produit_id)
                return $item['produit_indication'];
        }
        return '';
    }

    public static function sendTwilioSMS($mobile_number, $message){
        try {
            $client = new Client(env('TWILIO_ACCOUNT_SID'), env('TWILIO_AUTH_TOKEN'));
            $client->messages->create(
                $mobile_number,
                [
                    'from' => env('TWILIO_SENDER'),
                    'body' => $message,
                    'forceDelivery' => true,
                    'smartEncoded' => true,
                ]
            );
        }catch (\Exception $exception){
            //die($exception->getMessage());
        }
    }


    public static function convertYoutubeLink($link, $height, $width){
        return preg_replace(
            "/\s*[a-zA-Z\/\/:\.]*youtu(be.com\/watch\?v=|.be\/)([a-zA-Z0-9\-_]+)([a-zA-Z0-9\/\*\-\_\?\&\;\%\=\.]*)/i",
            "<iframe frameborder='0'   height='".$height."' width='".$width."' src=\"//www.youtube.com/embed/$2\" allowfullscreen></iframe>",
            $link
        );
    }

    public static function getPageLink($item){
        return url('accueil/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getCommuneLink($item){
        return url('communes/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getArticleLink($article){
        return url('articles/'.$article->id.'-'.Str::slug($article->name));
    }

    public static function getProjetLink($item){
        return url('projets/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getCommuniqueLink($item){
        return url('communiques/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getAppelProjetLink($item){
        return url('appel-a-projets/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getMarchePublicLink($item){
        return url('marches-publics/'.$item->id.'-'.Str::slug($item->name));
    }

    public static function getCategorieLink($categorie){
        return url('categorie/'.$categorie->id.'-'.Str::slug($categorie->name));
    }

    public static function getAlbumLink($album, $dtype){
        return url('galerie/'.$dtype.'/'.$album->id.'-'.Str::slug($album->name));
    }



    public static function affiche_date($date){
        if(empty($date)) return '';
        return date('d', strtotime($date)).' '.ucwords(\App\Utils\Agbonon::$months[date('m', strtotime($date))]).' '.date('Y', strtotime($date));
    }
}
