@extends('admin.template')

@section('title')
    Tableau de bord
@endsection

@section('main-content')
    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">{{config('app.name')}}</h4>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box table-responsive">
                @if($errors->count() > 0)
                    @foreach($errors->all() as $message)
                        <div class="alert alert-danger mg-b-0" role="alert">
                            <button aria-label="Close" class="close" data-dismiss="alert" type="button">
                                <span aria-hidden="true">×</span>
                            </button>
                            {!! $message !!}
                        </div>
                    @endforeach
                @endif

                @if(Session::has('success'))
                    <div class="alert alert-success mg-b-0" role="alert">
                        <button aria-label="Close" class="close" data-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        {!! Session::get('success') !!}
                    </div>
                @endif

                @if(Session::has('error'))
                    <div class="alert alert-danger mg-b-0" role="alert">
                        <button aria-label="Close" class="close" data-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        {!! Session::get('error') !!}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@section('my-scripts')

@endsection
