@extends('admin.template')

@section('title')
    Tableau de bord
@endsection

@section('main-content')
    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">Tableau de bord</h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="#">Tableau de bord</a>
                    </li>
                    <li class="active">
                        Tableau de bord
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>

    <style>
        .tilebox-two i{
            font-size: 25px;
            margin-top: 0;
        }

        .tilebox-two span{
            font-size: 12px;
            border-bottom: 1px solid #D7385E;
            color: #D7385E;
            cursor: pointer;
        }

        .tilebox-two span b{
            font-size: 15px;
        }

        .table>tbody>tr>td{
            color: #000000;
        }

        .tilebox-success {
            border-left-color: #dedede;
            border-left-width: 1px;
        }

        .table>tbody>tr>td{
            padding: 5px 5px;
        }
    </style>

    <?php
    $today = date('Y-m-d');
    $first_day_month = date('Y-m-01');
    ?>

    <div class="row">
        <div class="col-sm-12">
            <div class="card-box">
                <form action="" id="form-filter-dashboard" >
                    <div class="row">
                        <div class="col-sm-4">
                            <label for="" class="control-label">Période</label>
                            <div class="input-group" style="width: 100%">
                                <input type="text" readonly class="form-control" id="dash-periode" value="{{\App\Utils\Agbonon::date('d/m/Y', $today)}} - {{\App\Utils\Agbonon::date('d/m/Y',$today )}}" name="periode">
                            </div>
                        </div>

                        <div class="col-sm-2 btn-filter-home" >
                            <button type="submit" id="btn-apply-dashboard" class="btn btn-primary btn-sm waves-effect waves-light float-left">
                                <i class="fa fa-filter"></i> Apply
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-sm-12">
            <div id="c-ajax-dashboard">

            </div>
        </div>

        <div class="col-sm-12">
            <div class="card-box table-responsive">
                <h4 class="m-t-0">Maintenances</h4>
                <div id="view-ajax-maintenance-list">

                </div>
            </div>
        </div>
    </div>

@endsection

@section('my-scripts')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dash-periode').daterangepicker(
                {alwaysShowCalendars: !0,
                    locale: {
                        format: 'DD/MM/YYYY',
                        "separator": " - ",
                        "applyLabel": "Valider",
                        "cancelLabel": "Annuler",
                        "fromLabel": "De",
                        "toLabel": "A",
                        "customRangeLabel": "Custom",
                        "daysOfWeek": [
                            "Dim",
                            "Lun",
                            "Mar",
                            "Mer",
                            "Jeu",
                            "Ven",
                            "Sam"
                        ],
                        "monthNames": [
                            "Janvier",
                            "Février",
                            "Mars",
                            "Avril",
                            "Mai",
                            "Juin",
                            "Juillet",
                            "Août",
                            "Septembre",
                            "Octobre",
                            "Novembre",
                            "Décembre"
                        ],
                        "firstDay": 1
                    },
                    ranges: {
                        "30 derniers jours": [moment().subtract(29, "days"), moment()],
                        "Le mois en cours": [moment().startOf("month"), moment().endOf("month")],
                        "Le mois dernier": [moment().subtract(1, "month").startOf("month"), moment().subtract(1, "month").endOf("month")],
                        "3 derniers mois": [moment().subtract(3, "month"), moment()],
                        "12 derniers mois": [moment().subtract(12, "month"), moment()],
                    },
                },
                function (t, a, e) {
                    //alert( t.format("YYYY-MM-DD") + " to " + a.format("YYYY-MM-DD"));
                }
            );
        });
    </script>


    <script !src="">
        $('#form-filter-dashboard').on('submit', function (e) {
            e.preventDefault();
            var req = $.ajax({
                url: '{{url(config('app.admin_prefix').'/maintenance/ajax_list')}}',
                type: "GET",
                data: $('#form-filter-dashboard').serialize(),
                dataType: "html"
            });
            req.done(function (response, textStatus, jqXHR) {
                $('#view-ajax-maintenance-list').html(response);
            });
            req.fail(function (jqXHR, textStatus) {
                swal("Erreur!", "Erreur lors de l'opération.", "warning");
            });
        });
        $('#btn-apply-dashboard').click();
    </script>
@endsection
