@extends('admin.template')
@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">{{$model->getTitle()}} </h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li class="active">
                        {{$model->getTitle()}}
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>


    @include('admin.inc.cruds.btn_add')

    @include('admin.inc.cruds.'.$model->getFormModal())

    <div class="row">
        <div class="col-sm-12">
            <div class="card-box table-responsive">
                {{--<h4 class="m-t-0 header-title"><b>{{$model->getTitle()}}</b></h4>--}}
                @include('admin.inc.cruds.simple_table')
            </div>
        </div>
    </div>

    @if($model->getTable()=='sondages')
        <div class="row">
            <div class="col-sm-12">
                <div class="card-box table-responsive">
                    Cliquez pour copier le code d'intégration externe
                    <input  title="Code copié" class="btn btn-default btn-xs copy_text form-control" type="text" readonly value='<iframe allow="encrypted-media;picture-in-picture"  width="500" height="550" src="https://lelite.press/external_survey" frameborder="0"></iframe>"' />
                </div>
            </div>
        </div>
    @endif


@endsection



@section('my-scripts-2')
    <script>
        $(document).ready(function () {
            $('.copy_text').tooltipster({trigger:"click"});

            $('.copy_text').on('click', function () {
                var copyText = $(this);
                copyText.select();
                //copyText.setSelectionRange(0, 99999); /*For mobile devices*/
                document.execCommand("copy");
            });
        });

    </script>
@endsection

