@extends('admin.template')

@section('title') New issue @endsection

@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">New issue</h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="{{url(config('app.admin_prefix').'/maintenance')}}">Maintenance</a>
                    </li>
                    <li class="active">
                        Edition
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>

    <style>
        .form-horizontal .form-group{
            margin: 0;
            margin-top: 5px;
        }
    </style>

    <?php
    $stores = \Illuminate\Support\Facades\DB::table('stores')
        ->join('store_user','store_user.store_id','=', 'stores.id')
        ->where('store_user.user_id', Auth::user()->id)
        ->select('stores.*')
        ->get();

    $categories = \Illuminate\Support\Facades\DB::table('categories')
        ->select('categories.*')
        ->get();

    $subcategories = \Illuminate\Support\Facades\DB::table('subcategories')
        ->select('subcategories.*')
        ->get();
    ?>
    <div class="row">
        <div class="col-md-10 col-lg-7 col-sm-12">
            <div class="card-box">
                <form method="POST" action="{{url(config('app.admin_prefix').'/maintenance')}}" enctype="multipart/form-data" class="form-horizontal form-label-left input_mask">
                    {{csrf_field()}}
                    <input type="hidden" name="maintenance_id" value="{{$maintenance->id}}">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="store_id" class="control-label">Store</label>
                                <select required  class="form-control select2" name="store_id" id="store_id">
                                    <option value="">*Choose</option>
                                    @foreach($stores as $store)
                                        <option @if(old('store_id',$maintenance->store_id)==$store->id) selected @endif value="{{$store->id}}">{{$store->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="subject" class="control-label">Short description</label>
                                <input required name="subject" id="subject" type="text" class="form-control" value="{{old('subject', $maintenance->subject)}}" placeholder="Enter short description">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="categorie_id" class="control-label">Parent category</label>
                                <select required class="form-control select2" name="categorie_id" id="categorie_id">
                                    <option value="">*Choose</option>
                                    @foreach($categories as $categorie)
                                        <option @if(old('categorie_id',$maintenance->categorie_id)==$categorie->id) selected @endif value="{{$categorie->id}}">{{$categorie->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group" id="subcategorie-container">

                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="photo" class="control-label">Picture</label>
                                <input type="file" name="photo" id="photo" class="image-input" data-default-file="@if($maintenance->photo!=null){{url($maintenance->photo)}}@endif">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description" class="control-label">Other information</label>
                                <textarea name="description" id="description" class="form-control">{{old('description',$maintenance->description)}}</textarea>
                            </div>
                        </div>

                        <div class="col-sm-12 m-t-10">
                            <button type="submit" class="btn btn-sm btn-success waves-effect waves-light pull-right">Save</button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection



@section('my-scripts')

    <script>
        $(document).ready(function () {

            $(window).keydown(function (e) {
                if(e.keyCode == 13){
                    e.preventDefault();
                    return false;
                }
            });

            $(".select2").select2();

            $(document).on('change','#categorie_id',function (e) {
                e.preventDefault();
                var req = $.ajax({
                    url: '{{url(config('app.admin_prefix').'/subcategories')}}',
                    type: "GET",
                    data: {categorie_id : $('#categorie_id').val(), old_subcateg_id: {{$maintenance->subcategorie_id!=null? $maintenance->subcategorie_id : '0'}}},
                    dataType: "html"
                });

                req.done(function (response, textStatus, jqXHR) {
                   $('#subcategorie-container').html(response)
                });
                req.fail(function (jqXHR, textStatus) {
                });
            });

        });
    </script>
@endsection
