@extends('admin.template')

@section('title') New issue @endsection

@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">New issue</h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="{{url(config('app.admin_prefix').'/maintenance')}}">Maintenance</a>
                    </li>
                    <li class="active">
                        Detail
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>

    <style>
        .form-horizontal .form-group{
            margin: 0;
            margin-top: 5px;
        }
    </style>


    <div class="row">
        <div class="col-md-10 col-lg-7 col-sm-12">
            <div class="card-box">
                <table id="main" align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr style="">
                        <td style="font-size: 14px; line-height: 20px; padding: 15px 15px 30px 15px;">

                            <table class="issue-table" style="width: 100%; margin-bottom: 15px"   border="1">
                                <tbody>
                                <tr>
                                    <td>Parent category</td>
                                    <td>{{$issue->categorie->name}}</td>
                                </tr>
                                <tr>
                                    <td>Child category</td>
                                    <td>{{$issue->subcategorie->name}}</td>
                                </tr>
                                <tr>
                                    <td>Description</td>
                                    <td>{{$issue->subject}}</td>
                                </tr>
                                <tr>
                                    <td>Notes</td>
                                    <td>{{$issue->description}}</td>
                                </tr>

                                @if(!empty($issue->photos))
                                    <tr>
                                        <td colspan="2" style="background-color: #f4f4f4">
                                            <img style="width: 100%" src="{{url($issue->photos)}}" alt="">
                                        </td>
                                    </tr>
                                @endif

                                </tbody>
                            </table>

                            <h3>Store</h3>
                            <table style="width: 100%; margin-bottom: 15px" collapse="collapse">
                                <tbody>
                                <tr>
                                    <td>{{$issue->store->name}}</td>
                                </tr>
                                <tr>
                                    <td>{{$issue->store->phone}}</td>
                                </tr>
                                </tbody>
                            </table>

                            <h3>Logged By</h3>
                            <table style="width: 100%; margin-bottom: 15px" collapse="collapse">
                                <tbody>
                                <tr>
                                    <td>{{$issue->createdUser->name}}</td>
                                </tr>
                                <tr>
                                    <td>{{$issue->createdUser->email}}</td>
                                </tr>
                                </tbody>
                            </table>

                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

@endsection



@section('my-scripts')

    <script>
        $(document).ready(function () {

            $(window).keydown(function (e) {
                if(e.keyCode == 13){
                    e.preventDefault();
                    return false;
                }
            });


        });
    </script>
@endsection
