@extends('admin.template')
@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">{{$model->getTitle()}} </h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="{{url(config('app.admin_prefix').'/statu')}}">{{$model->getTitle()}}</a>
                    </li>
                    <li class="active">
                        Edition
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>


    <style>
        .jFiler-item{
            position: relative;
        }
    </style>

    <form method="POST" action="{{url(config('app.admin_prefix').'/statu')}}" enctype="multipart/form-data" class="form-horizontal form-label-left input_mask">
        <div class="row">
            <div class="col-sm-8 col-lg-push-2">
                <div class="card-box table-responsive" style="padding-bottom: 150px">
                    @include('admin.inc.cruds.'.$model->getFormModal())
                </div>
            </div>

        </div>

    </form>
@endsection





@section('my-scripts')

    <script>
        $(document).ready(function () {

            $(window).keydown(function (e) {
                if(e.keyCode == 13){
                    e.preventDefault();
                    return false;
                }
            });


            $(".select2").select2();


        });
    </script>
@endsection
