@extends('admin.template')
@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">{{$model->getTitle()}} </h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="{{url(config('app.admin_prefix').'/article')}}">{{$model->getTitle()}}</a>
                    </li>
                    <li class="active">
                        Edition
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>

    <form method="POST" action="{{url(config('app.admin_prefix').'/suggestion')}}" enctype="multipart/form-data" class="form-horizontal form-label-left input_mask">
        {{csrf_field()}}
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box table-responsive" style="min-height: 300px">
                <?php
                $questions =  DB::table('questions')->whereIn('type_answer',['C','CM'])->get();
                $currentQuestion = \App\Models\Question::find($model->question_id);
                $nb_suggestion =  DB::table('suggestions')->where('question_id',$model->question_id)->count();
                ?>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="question_id" class="control-label">Questions</label>
                        <select  class="form-control select2" name="question_id" id="question_id">
                            <option value="">*Choose</option>
                            @foreach($questions as $question)
                                <option @if($question->id==$model->question_id) selected @endif value="{{$question->id}}">{{$question->phrase}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="nb_sugg" class="control-label">Nb. suggestion</label>
                        <select  class="form-control" name="nb_sugg" id="nb_sugg">
                            @for($i=1; $i<20 ; $i++)
                                <option @if($i==$nb_suggestion) selected @endif  value="{{$i}}">{{$i}}</option>
                            @endfor
                        </select>
                    </div>
                </div>


                <div class="col-sm-12 m-t-20">
                    <h3 class="">Suggestions</h3>

                    <div id="suggestion-input">

                    </div>
                </div>


                <div class="col-sm-12">
                    <button type="submit" class="btn btn-sm btn-success waves-effect waves-light pull-right">Save</button>
                </div>
            </div>
        </div>
    </div>



    </form>
@endsection

@section('my-css')
   <link href='{{asset('admin/css/redempteur-bis.css')}}' rel='stylesheet' type='text/css' />
@endsection

@section('my-scripts')

    <script>
        $(document).ready(function () {
            $(".select2").select2();


            $(document).on('change','#question_id',function () {
                if($('#nb_sugg').val()!=''){
                    var req = $.ajax({
                        url: '{{url(config('app.admin_prefix').'/add_suggestion')}}',
                        type: "GET",
                        data: {question_id: $('#question_id').val(), nb_sugg : $('#nb_sugg').val()},
                        dataType: "html"
                    });
                    req.done(function (response, textStatus, jqXHR) {
                        $('#suggestion-input').html(response);
                    });
                    req.fail(function (jqXHR, textStatus) {
                        $('#suggestion-input').html('');
                    });
                }
            });

            $(document).on('change','#nb_sugg',function () {
                $('#question_id').change();
            });


            $('#nb_sugg').change();
        });
    </script>
@endsection
