@extends('admin.template')
@section('main-content')

    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title">{{$model->getTitle()}} </h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#">{{config('app.name')}}</a>
                    </li>
                    <li>
                        <a href="{{url(config('app.admin_prefix').'/user')}}">{{$model->getTitle()}}</a>
                    </li>
                    <li class="active">
                        Edition
                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>


    <style>
        .jFiler-item{
            position: relative;
        }
    </style>

    <form method="POST" action="{{url(config('app.admin_prefix').'/user')}}" enctype="multipart/form-data" class="form-horizontal form-label-left input_mask">

        <div class="row">
            <div class="col-sm-8">
                <div class="card-box table-responsive">
                    @include('admin.inc.cruds.'.$model->getFormModal())
                </div>
            </div>

            <?php
            $categ_ids = $model->categories->pluck('id')->toArray();
            ?>

            <div class="col-sm-3">
                <div class="card-box table-responsive">
                    <h3 class="panel-title m-b-15 p-b-10">Work categories</h3>
                    @foreach(\App\Models\Categorie::all() as $c)
                        <div class="checkbox checkbox-custom">
                            <input  @if(in_array($c->id,$categ_ids)) checked @endif id="check_c{{$c->id}}" name="check_c{{$c->id}}" type="checkbox">
                            <label for="check_c{{$c->id}}">
                                {{$c->name}}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

    </form>
@endsection





@section('my-scripts')

    <script>
        $(document).ready(function () {

            $(window).keydown(function (e) {
                if(e.keyCode == 13){
                    e.preventDefault();
                    return false;
                }
            });


            $(".select2").select2();


        });
    </script>
@endsection
