<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>{{config('app.name')}}</title>
    <style type="text/css">
        table{
            font-family: "Roboto", Arial, sans-serif;
        }
        #main-container{
            width: 600px;
            margin: 10px auto;
        }
        @media screen and (max-width: 600px) {
            #main-container{
                width: 100% !important;
            }
        }

        .job-item{
            width: 100%;
            background-color: #f4f4f4;
            margin: 10px 0;
            padding: 5px 10px;
        }


        .item-label{
            font-size: 11px;
            color: #1351aa;
        }

        .item-value{
            font-size: 13px;
        }

        .mt-7{
            margin-top: 7px;
        }
    </style>
</head>


<body style="margin: 15px 0;background-color: #ffffff !important;">
<div id="main-container">
    @foreach($late_jobs as $late_job)
        <div class="mt-7"></div>
        <div class="job-item">
            <div style="float: right">
                <span class="item-label">Created at </span>
                <div class="item-value">{{$late_job['created_date'].' '.$late_job['created_time']}}</div>

                <div class="mt-7"></div>
                <span class="item-label">Status </span>
                <div class="item-value" style="color: {{$late_job['status_color']}}">{{$late_job['status']}}</div>
            </div>
            <span class="item-label">Job Number</span>
            <div class="item-value">{{$late_job['number']}}</div>

            <div class="mt-7"></div>
            <span class="item-label">Category</span>
            <div class="item-value">{{$late_job['category']['name']}} @if(!empty($late_job['subcategory'])){{', '.$late_job['subcategory']['name']}}@endif</div>

            <div class="mt-7"></div>
            <span class="item-label">Description</span>
            <div class="item-value">
                {{$late_job['subject']}}. <br>
                @if(!empty($late_job['description']))
                    {{$late_job['description']}}
                @endif
            </div>

            <div class="mt-7"></div>
            <span class="item-label">Store</span>
            <div class="item-value">{{$late_job['store']['name']}}</div>
        </div>
        <div class="mt-7"></div>
    @endforeach
</div>
</body>
</html>
