<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


date_default_timezone_set('Africa/Libreville');

Route::group(['namespace'=>'\\App\\Http\\Controllers', 'middleware'=>'verify-app-client'], function(){
    Route::get('testpush', 'TestController@testPush');

    Route::get('late_job_notification', 'HomeController@lateJobNotification');

    Route::get('unauthorized', 'UserController@unauthorized');
    Route::post('login', 'UserController@login');
    Route::post('device', 'UserController@saveDevice');

    Route::middleware(['api-auth'])->group(function () {
        Route::get('categorys/{begin?}/{size?}', 'CategorieController@apiliste');
        Route::get('subcategorys/{begin?}/{size?}', 'SubcategorieController@apiliste');
        Route::get('status/{begin?}/{size?}', 'StatuController@apiliste');
        Route::get('maintenances/{begin?}/{size?}', 'MaintenanceController@apiliste');
        Route::get('maintenance/{_id}', 'MaintenanceController@apidetail');
        Route::post('maintenance', 'MaintenanceController@apisave');
        Route::get('stores/{begin?}/{size?}', 'StoreController@apiliste');
        Route::post('maintenance/{_id}/status', 'MaintenanceController@saveStatus');
        Route::post('message', 'MessageController@saveMessage');
        Route::get('messages/{begin?}/{size?}', 'MessageController@listMessage');
        Route::get('awaiting_part/{begin?}/{size?}', 'MaintenanceController@awaitingPart');
        Route::get('maintenance-status/', 'MaintenanceController@checkStatus');
        Route::get('issue-users/{id_maintance}', 'MaintenanceController@issueUsers');
    });
    //Route::get('maintenance/checkStatus/', 'MaintenanceController@checkStatus');
});





/*Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});*/


