<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('mail_view',  function (){
    //$issue =  \App\Models\Maintenance::find(1);
    //return view('emails.new-issue', ['issue'=>$issue]);
    return  $_SERVER['SERVER_NAME'];
});

Route::get('policy',  function (){
    return view('policy');
});


Route::group(['prefix' => config('app.admin_prefix'), 'namespace'=>'\\App\\Http\\Controllers', 'middleware'=>'verify-web-client'], function(){

    //'auth',
    Route::group(['middleware'=> ['auth','admin-auth']], function(){
        Route::get('add_suggestion', 'HomeController@statSugg');
        Route::get('subcategories', 'HomeController@subCategories');
        Route::get('/',  'HomeController@index');
        Route::get('/home',  'HomeController@index');
        \App\Utils\Agbonon::crudResource('menu','MenuController');
        \App\Utils\Agbonon::crudResource('companie','CompanieController');
        \App\Utils\Agbonon::crudResource('country','CountryController');
        \App\Utils\Agbonon::crudResource('region','RegionController');
        \App\Utils\Agbonon::crudResource('brand','BrandController');
        \App\Utils\Agbonon::crudResource('store','StoreController');
        \App\Utils\Agbonon::crudResource('categorie','CategorieController');
        \App\Utils\Agbonon::crudResource('subcategorie','SubcategorieController');
        \App\Utils\Agbonon::crudResource('supplier','SupplierController');
        \App\Utils\Agbonon::crudResource('user','UserController');
        Route::get('user/add', 'UserController@formAdd');
        \App\Utils\Agbonon::crudResource('statu','StatuController');
        Route::get('statu/add', 'StatuController@formAdd');
        \App\Utils\Agbonon::crudResource('maintenances/{_dtype}','MaintenanceController');
        Route::get('maintenance/add', 'MaintenanceController@formAdd');
        Route::post('maintenance', 'MaintenanceController@save');
        Route::get('maintenance/ajax_list', 'MaintenanceController@ajaxList');
        Route::get('status/maintenance', 'MaintenanceController@saveStatus');
        Route::get('information', 'HomeController@extMessage');
        Route::get('maintenance/{_id}/status', 'MaintenanceController@saveStatus');
        Route::get('maintenance/{_id}/detail', 'MaintenanceController@detailJob');
    });

    Auth::routes();
    Route::get('logout', 'Auth\LoginController@logout');
});


Route::get('503', function () {
    return 'Unauthorized access';
});

Route::get('404', function () {
    return 'Page not found';
});
