<style>
    #list-maintenance_info, #list-maintenance_paginate, #list-maintenance_filter{
        display: none;
    }
    .dt-buttons{
        float: right;
    }
    @media  print{
        .actions{
            display : none;
        }
    }

    td span{
        color: #585858;
        font-size: 10px;
    }
</style>

<?php
$maintenances = \App\Models\Maintenance::select('*');

$dtype =  $request->get('data-type');
$start_date = null;
$end_date = null;
if(!empty($request->get('periode'))){
    $tab = explode(' - ',$request->get('periode'));
    $start_date = date('Y-m-d 00:00',strtotime(str_replace('/','-',$tab[0])));
    $end_date = date('Y-m-d 23:59',strtotime(str_replace('/','-',$tab[1])));
}
$statu_ids = !empty($request->get('statu_id'))? $request->get('statu_id') :  null;
$store_ids = !empty($request->get('store_id'))? $request->get('store_id') :  null;
$categorie_ids = !empty($request->get('categorie_id'))? $request->get('categorie_id') :  null;
$subcategorie_ids = !empty($request->get('subcategorie_id'))? $request->get('subcategorie_id') :  null;
$supervisor_user_id = !empty($request->get('supervisor_user_id'))? $request->get('supervisor_user_id') :  null;
$officer_user_id = !empty($request->get('officer_user_id'))? $request->get('officer_user_id') :  null;
$created_user_id = !empty($request->get('created_user_id'))? $request->get('created_user_id') :  null;
$limit = !empty($request->get('limit'))? $request->get('limit') :  null;

$maintenances = \App\Models\Maintenance::liste('',null,$dtype,$start_date,$end_date,$statu_ids,$store_ids,$categorie_ids,$subcategorie_ids,$supervisor_user_id,$officer_user_id,$created_user_id,0,$limit);


$profil_status =  \App\Models\Profil::getStatus(Auth::user()->profil_id)->pluck('id')->toArray();

?>

<table id="list-maintenance" class="table table-striped table-bordered  dt-responsive nowrap" cellspacing="0" width="100%">
    <thead>
    <tr>
        <th>#Ref</th>
        <th>Store</th>
        <th>Category</th>
        <th>Subject</th>
        <th>Logged by</th>
        <th>Date</th>
        <th>Status</th>
        <th>Actions</th>
    </tr>
    </thead>
    <tbody>

    <?php $__currentLoopData = $maintenances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $maintenance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $start_date  =  !empty($maintenance->start_date)? $maintenance->start_date :  date('Y-m-d H:i:s');
        $days_passed = abs(strtotime($start_date) - strtotime($maintenance->created_at)) / (60*60*24);
        ?>
        <tr <?php if($days_passed>=7 && $maintenance->statu_id != \App\Models\Statu::COMPLETED_CONFIRMED): ?> style="background-color: #fdd1b8a3" <?php endif; ?>>
            <td>
                <?php echo e($maintenance->number); ?>

                <?php if($days_passed>=7): ?>
                    <div style="background-color: red; color: #fff; padding: 0 7px;  display: inherit; font-size: 11px">Overdue</div>
                <?php endif; ?>
            </td>
            <td><?php echo e($maintenance->store->name); ?></td>
            <td>
                <?php echo e($maintenance->categorie->name); ?><br>
                <?php if($maintenance->subcategorie!=null): ?><span><?php echo e($maintenance->subcategorie->name); ?></span><?php endif; ?>
            </td>
            <td><?php echo e($maintenance->subject); ?></td>
            <td>
                <?php echo e($maintenance->createdUser->name); ?><br>
                <span><?php echo e($maintenance->createdUser->email); ?></span>
            </td>
            <td><?php echo e(date('d-m-Y H:i', strtotime($maintenance->created_at))); ?></td>
            <td>
                <div style="background-color: <?php echo e(\App\Models\Statu::STATUS_COLORS[$maintenance->statu_id]); ?> ;color: #fff; padding: 0 7px;  display: inherit; font-size: 11px"><?php echo e($maintenance->statu->name); ?></div>
            </td>
            <td>
                <?php echo $maintenance->btnOptions($profil_status); ?>

            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<script>
    $('#list-maintenance').DataTable({
        "pageLength": 10,
        "ordering": false,
        "dom": 'Bfrtip C<"clear">lfrtip',
        "buttons": [{
            extend: "excel",
            className: "btn-sm",
            text: 'Exporter en Excel',
            exportOptions: {
                columns: ':not(:last-child)',
            }
        },
            {
                extend: "print",
                className: "btn-sm",
                text: 'Imprimer',
                customize : function ( win ) {
                    body = $(win.document.body);
                    body.find('h1').remove();
                    table = body.find('table');
                    table.find('tr th:last-child, tr td:last-child').remove();
                    entete= '<table id="main" align="center" border="0" cellpadding="0" cellspacing="0" width="100%" bgcolor="#fff" style="color: #393939;">\n' +
                        '    <tr style="">\n' +
                        '        <td style="padding: 15px; padding-top: 30px ; " colspan="2" align="center">\n' +
                        '            <h2 style="margin: 0 0 0 0;  border: 1px solid #72a230;">Historique des commandes</h2>\n' +
                        '        </td>\n' +
                        '    </tr>\n' +
                        '</table>';
                    body.html(entete+body.html());
                }
            }],
        "colVis": {
            "buttonText": "Colonnes affichées"
        }
    });
</script>
<?php /**PATH /home/nader/public_html/maintenance.resto-group.com/resources/views/admin/ajax/maintenance-list.blade.php ENDPATH**/ ?>