<?php $__env->startSection('title'); ?>
    <?php echo e($pageTitle); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-content'); ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="page-title-box">
                <h4 class="page-title"> <?php echo e($pageTitle); ?></h4>
                <ol class="breadcrumb p-0 m-0">
                    <li>
                        <a href="#"><?php echo e(config('app.name')); ?></a>
                    </li>
                    <li>
                        <a href="#"> <?php echo e($pageTitle); ?></a>
                    </li>
                    <li class="active">
                        <?php echo e($pageTitle); ?>

                    </li>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>

    <style>
        .tilebox-two i{
            font-size: 25px;
            margin-top: 0;
        }

        .tilebox-two span{
            font-size: 12px;
            border-bottom: 1px solid #D7385E;
            color: #D7385E;
            cursor: pointer;
        }

        .tilebox-two span b{
            font-size: 15px;
        }

        .table>tbody>tr>td{
            color: #000000;
        }

        .tilebox-success {
            border-left-color: #dedede;
            border-left-width: 1px;
        }

        .table>tbody>tr>td{
            padding: 5px 5px;
        }
    </style>

    <?php
    $today = date('Y-m-d');
    $first_day_month = date('Y-m-01');
    ?>

    <div class="row">
        <div class="col-sm-12">
            <div class="card-box">
                <form action="" id="form-filter-maintenance" >
                    <input type="hidden" name="data-type" value="<?php echo e($dtype); ?>">
                    <div class="row">
                        <div class="col-sm-3">
                            <label for="" class="control-label">Dates</label>
                            <div class="input-group" style="width: 100%">
                                <input type="text" readonly class="form-control" id="date-period" value="<?php echo e(\App\Utils\Agbonon::date('d/m/Y', $first_day_month)); ?> - <?php echo e(\App\Utils\Agbonon::date('d/m/Y',$today )); ?>" name="periode">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <label for="store_id" class="control-label">Store</label>
                            <select multiple  class="form-control select2" name="store_id[]" id="store_id" data-placeholder="Choose ...">
                                <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($store->id); ?>"><?php echo e($store->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-sm-3">
                            <label for="statu_id" class="control-label">Status</label>
                            <select multiple  class="form-control select2" name="statu_id[]" id="statu_id" data-placeholder="Choose ...">
                                <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($statu->id); ?>"><?php echo e($statu->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-sm-3">
                            <label for="categorie_id" class="control-label">Categories</label>
                            <select multiple  class="form-control select2" name="categorie_id[]" id="categorie_id" data-placeholder="Choose ...">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($categorie->id); ?>"><?php echo e($categorie->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-sm-12 m-t-5" align="right">
                            <button type="submit" id="btn-apply-filter" class="btn btn-primary btn-sm waves-effect waves-light ">
                                <i class="fa fa-refresh"></i> Apply
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-sm-12" style="color: ">
            <div class="card-box table-responsive">
                <h4 class="m-t-0">Maintenances - <?php echo e($pageTitle); ?></h4>
                <div id="view-ajax-maintenance-list">

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('my-scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function () {

            $('#date-period').daterangepicker(
                {alwaysShowCalendars: !0,
                    locale: {
                        format: 'DD/MM/YYYY',
                        "separator": " - ",
                        "applyLabel": "Valider",
                        "cancelLabel": "Annuler",
                        "fromLabel": "De",
                        "toLabel": "A",
                        "customRangeLabel": "Custom",
                        "daysOfWeek": [
                            "Dim",
                            "Lun",
                            "Mar",
                            "Mer",
                            "Jeu",
                            "Ven",
                            "Sam"
                        ],
                        "monthNames": [
                            "Janvier",
                            "Février",
                            "Mars",
                            "Avril",
                            "Mai",
                            "Juin",
                            "Juillet",
                            "Août",
                            "Septembre",
                            "Octobre",
                            "Novembre",
                            "Décembre"
                        ],
                        "firstDay": 1
                    },
                    ranges: {
                        "30 derniers jours": [moment().subtract(29, "days"), moment()],
                        "Le mois en cours": [moment().startOf("month"), moment().endOf("month")],
                        "Le mois dernier": [moment().subtract(1, "month").startOf("month"), moment().subtract(1, "month").endOf("month")],
                        "3 derniers mois": [moment().subtract(3, "month"), moment()],
                        "12 derniers mois": [moment().subtract(12, "month"), moment()],
                    },
                },
                function (t, a, e) {
                    //alert( t.format("YYYY-MM-DD") + " to " + a.format("YYYY-MM-DD"));
                }
            );

            $('#form-filter-maintenance').on('submit', function (e) {
                e.preventDefault();
                var req = $.ajax({
                    url: '<?php echo e(url(config('app.admin_prefix').'/maintenance/ajax_list')); ?>',
                    type: "GET",
                    data: $('#form-filter-maintenance').serialize(),
                    dataType: "html"
                });
                req.done(function (response, textStatus, jqXHR) {
                    $('#view-ajax-maintenance-list').html(response);
                });
                req.fail(function (jqXHR, textStatus) {
                    swal("Erreur!", "Erreur lors de l'opération.", "warning");
                });
            });
            $('#btn-apply-filter').click();
        });
    </script>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nader/public_html/maintenance.resto-group.com/resources/views/admin/maintenances/list.blade.php ENDPATH**/ ?>